/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import com.caucho.hessian.client.HessianRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class BurlapClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor,
InitializingBean {
    private final BurlapProxyFactory proxyFactory = new BurlapProxyFactory();
    private Object burlapProxy;

    public void setUsername(String username) {
        this.proxyFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.proxyFactory.setPassword(password);
    }

    public void afterPropertiesSet() throws MalformedURLException {
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("serviceInterface is required");
        }
        if (this.getServiceUrl() == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        this.burlapProxy = this.proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.getMethod().invoke(this.burlapProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            this.logger.debug((Object)("Burlap service [" + this.getServiceUrl() + "] threw exception"), ex.getTargetException());
            if (ex.getTargetException() instanceof HessianRuntimeException) {
                BurlapRuntimeException bre = (BurlapRuntimeException)ex.getTargetException();
                Object rootCause = bre.getRootCause() != null ? bre.getRootCause() : bre;
                throw new RemoteAccessException("Cannot access Burlap service", (Throwable)rootCause);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw new RemoteAccessException("Cannot access Burlap service", utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
    }
}

