/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.object.RdbmsOperation;
import org.springframework.jdbc.support.JdbcUtils;

public abstract class SqlOperation
extends RdbmsOperation {
    private boolean updatableResults;
    private PreparedStatementCreatorFactory preparedStatementFactory;

    protected void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    protected boolean isUpdatableResults() {
        return this.updatableResults;
    }

    protected PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return this.preparedStatementFactory.newPreparedStatementCreator(params);
    }

    protected final void compileInternal() {
        int bindVarCount = 0;
        try {
            bindVarCount = JdbcUtils.countParameterPlaceholders(this.getSql(), '?', '\'');
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataAccessApiUsageException(e.getMessage());
        }
        if (bindVarCount != this.getDeclaredParameters().size()) {
            throw new InvalidDataAccessApiUsageException("SQL '" + this.getSql() + "' requires " + bindVarCount + " bind variables, but " + this.getDeclaredParameters().size() + " variables were declared for this object");
        }
        this.preparedStatementFactory = new PreparedStatementCreatorFactory(this.getSql(), this.getDeclaredParameters(), this.updatableResults);
        this.onCompileInternal();
    }

    protected void onCompileInternal() {
    }
}

