/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.support;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import org.springframework.beans.factory.support.BootstrapException;
import org.springframework.ejb.support.AbstractSessionBean;

public abstract class AbstractStatelessSessionBean
extends AbstractSessionBean {
    public void ejbCreate() throws CreateException {
        try {
            this.loadBeanFactory();
        }
        catch (BootstrapException ex) {
            throw new CreateException(ex.getMessage());
        }
        this.onEjbCreate();
    }

    protected abstract void onEjbCreate() throws CreateException;

    public void ejbActivate() throws EJBException {
        throw new IllegalStateException("ejbActivate must not be invoked on a stateless session bean");
    }

    public void ejbPassivate() throws EJBException {
        throw new IllegalStateException("ejbPassivate must not be invoked on a stateless session bean");
    }
}

