/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRBshCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractJasperReportsView
extends AbstractUrlBasedView {
    private String reportDataKey;
    private Resource reportResource;
    private JasperReport report;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSource;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public void setReportDataKey(String reportDataKey) {
        this.reportDataKey = reportDataKey;
    }

    protected void initApplicationContext() throws ApplicationContextException {
        block7: {
            super.initApplicationContext();
            this.reportResource = this.getApplicationContext().getResource(this.getUrl());
            try {
                if (this.reportResource.getFilename().endsWith(".jasper")) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Loading pre-compiled Jasper Report from " + this.reportResource));
                    }
                    this.report = (JasperReport)JRLoader.loadObject((InputStream)this.reportResource.getInputStream());
                    break block7;
                }
                if (this.reportResource.getFilename().endsWith(".jrxml")) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Compiling Jasper Report loaded from " + this.reportResource));
                    }
                    JasperDesign design = JRXmlLoader.load((InputStream)this.reportResource.getInputStream());
                    this.report = this.getReportCompiler().compileReport(design);
                    break block7;
                }
                throw new IllegalArgumentException("Report URL must end in either .jasper or .jrxml");
            }
            catch (IOException ex) {
                throw new ApplicationContextException("Could not load JasperReports report for URL [" + this.getUrl() + "]", (Throwable)ex);
            }
            catch (JRException ex) {
                throw new ApplicationContextException("Could not parse JasperReports report for URL [" + this.getUrl() + "]", (Throwable)ex);
            }
        }
    }

    protected JRCompiler getReportCompiler() {
        return new JRBshCompiler();
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JRDataSource dataSource = this.getReportData(model);
        response.setContentType(this.getContentType());
        this.renderReport(this.report, model, dataSource, response);
    }

    protected JRDataSource getReportData(Map model) throws IllegalArgumentException {
        if (this.reportDataKey != null) {
            Object value = model.get(this.reportDataKey);
            return this.convertReportData(value);
        }
        Object value = CollectionUtils.findValueOfType(model.values(), (Class[])this.getReportDataTypes());
        if (value != null) {
            return this.convertReportData(value);
        }
        throw new IllegalArgumentException("No report data supplied in model " + model);
    }

    protected JRDataSource convertReportData(Object value) throws IllegalArgumentException {
        return JasperReportsUtils.convertReportData((Object)value);
    }

    protected Class[] getReportDataTypes() {
        return new Class[]{class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource, class$java$util$Collection == null ? (class$java$util$Collection = AbstractJasperReportsView.class$("java.util.Collection")) : class$java$util$Collection, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbstractJasperReportsView.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
    }

    protected void renderReport(JasperReport report, Map parameters, JRDataSource dataSource, HttpServletResponse response) throws Exception {
        JRAbstractExporter exporter = this.createExporter();
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)parameters, (JRDataSource)dataSource);
        if (this.useWriter()) {
            JasperReportsUtils.render((JRAbstractExporter)exporter, (JasperPrint)print, (Writer)response.getWriter());
        } else {
            JasperReportsUtils.render((JRAbstractExporter)exporter, (JasperPrint)print, (OutputStream)response.getOutputStream());
        }
    }

    protected abstract JRAbstractExporter createExporter();

    protected abstract boolean useWriter();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

