/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.web.util.WebUtils;

public abstract class Log4jWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";

    public static void initLogging(ServletContext servletContext) {
        block8: {
            WebUtils.setWebAppRootSystemProperty(servletContext);
            String location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
            if (location != null) {
                if (!location.startsWith("/")) {
                    location = "/" + location;
                }
                servletContext.log("Initializing Log4J from [" + location + "]");
                try {
                    String realPath = servletContext.getRealPath(location);
                    if (realPath == null) {
                        throw new FileNotFoundException("ServletContext resource [" + realPath + "] cannot be resolved to absolute file path - " + "web application archive not expanded?");
                    }
                    String intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
                    if (intervalString != null) {
                        try {
                            long refreshInterval = Long.parseLong(intervalString);
                            Log4jConfigurer.initLogging((String)realPath, (long)refreshInterval);
                            break block8;
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalArgumentException("Invalid 'log4jRefreshInterval' parameter: " + ex.getMessage());
                        }
                    }
                    Log4jConfigurer.initLogging((String)realPath);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + ex.getMessage());
                }
            }
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down Log4J");
        Log4jConfigurer.shutdownLogging();
    }
}

