/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDODataStoreException;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalDataStoreException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.jdo.JdoObjectRetrievalFailureException;
import org.springframework.orm.jdo.JdoOptimisticLockingFailureException;
import org.springframework.orm.jdo.JdoResourceFailureException;
import org.springframework.orm.jdo.JdoSystemException;
import org.springframework.orm.jdo.JdoUsageException;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class PersistenceManagerFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils == null ? (class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils = PersistenceManagerFactoryUtils.class$("org.springframework.orm.jdo.PersistenceManagerFactoryUtils")) : class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$jdo$PersistenceManagerFactoryUtils;

    public static SQLExceptionTranslator newJdbcExceptionTranslator(PersistenceManagerFactory pmf) {
        Object jdbcExceptionTranslator = null;
        Object cf = pmf.getConnectionFactory();
        jdbcExceptionTranslator = cf instanceof DataSource ? new SQLErrorCodeSQLExceptionTranslator((DataSource)cf) : new SQLStateSQLExceptionTranslator();
        return jdbcExceptionTranslator;
    }

    public static PersistenceManager getPersistenceManager(PersistenceManagerFactory pmf, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return PersistenceManagerFactoryUtils.getPersistenceManager(pmf, allowCreate, true);
    }

    public static PersistenceManager getPersistenceManager(PersistenceManagerFactory pmf, boolean allowCreate, boolean allowSynchronization) throws DataAccessResourceFailureException, IllegalStateException {
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)((Object)TransactionSynchronizationManager.getResource((Object)pmf));
        if (pmHolder != null) {
            return pmHolder.getPersistenceManager();
        }
        if (!allowCreate) {
            throw new IllegalStateException("No JDO persistence manager bound to thread, and configuration does not allow creation of new one here");
        }
        logger.debug((Object)"Opening JDO persistence manager");
        try {
            PersistenceManager pm = pmf.getPersistenceManager();
            if (allowSynchronization && TransactionSynchronizationManager.isSynchronizationActive()) {
                logger.debug((Object)"Registering transaction synchronization for JDO persistence manager");
                pmHolder = new PersistenceManagerHolder(pm);
                TransactionSynchronizationManager.bindResource((Object)pmf, (Object)((Object)pmHolder));
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new PersistenceManagerSynchronization(pmHolder, pmf));
            }
            return pm;
        }
        catch (JDOException ex) {
            throw new DataAccessResourceFailureException("Cannot get JDO persistence manager", (Throwable)ex);
        }
    }

    public static DataAccessException convertJdoAccessException(JDOException ex) {
        if (ex instanceof JDOObjectNotFoundException) {
            throw new JdoObjectRetrievalFailureException((JDOObjectNotFoundException)ex);
        }
        if (ex instanceof JDOOptimisticVerificationException) {
            throw new JdoOptimisticLockingFailureException((JDOOptimisticVerificationException)ex);
        }
        if (ex instanceof JDODataStoreException) {
            return new JdoResourceFailureException((JDODataStoreException)ex);
        }
        if (ex instanceof JDOFatalDataStoreException) {
            return new JdoResourceFailureException((JDOFatalDataStoreException)ex);
        }
        if (ex instanceof JDOUserException) {
            return new JdoUsageException((JDOUserException)ex);
        }
        if (ex instanceof JDOFatalUserException) {
            return new JdoUsageException((JDOFatalUserException)ex);
        }
        return new JdoSystemException(ex);
    }

    public static void closePersistenceManagerIfNecessary(PersistenceManager pm, PersistenceManagerFactory pmf) {
        if (pm == null || TransactionSynchronizationManager.hasResource((Object)pmf)) {
            return;
        }
        logger.debug((Object)"Closing JDO persistence manager");
        try {
            pm.close();
        }
        catch (JDOException ex) {
            logger.error((Object)"Cannot close JDO persistence manager", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PersistenceManagerSynchronization
    extends TransactionSynchronizationAdapter {
        private final PersistenceManagerHolder persistenceManagerHolder;
        private final PersistenceManagerFactory persistenceManagerFactory;

        private PersistenceManagerSynchronization(PersistenceManagerHolder pmHolder, PersistenceManagerFactory pmf) {
            this.persistenceManagerHolder = pmHolder;
            this.persistenceManagerFactory = pmf;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.persistenceManagerFactory);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.persistenceManagerFactory, (Object)((Object)this.persistenceManagerHolder));
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.persistenceManagerFactory);
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(this.persistenceManagerHolder.getPersistenceManager(), this.persistenceManagerFactory);
        }
    }
}

