/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.RowHandler;
import com.ibatis.db.sqlmap.SqlMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.orm.ibatis.SqlMapCallback;
import org.springframework.orm.ibatis.SqlMapOperations;

public class SqlMapTemplate
extends JdbcAccessor
implements SqlMapOperations {
    private SqlMap sqlMap;

    public SqlMapTemplate() {
    }

    public SqlMapTemplate(DataSource dataSource, SqlMap sqlMap) {
        this.setDataSource(dataSource);
        this.setSqlMap(sqlMap);
        this.afterPropertiesSet();
    }

    public void setSqlMap(SqlMap sqlMap) {
        this.sqlMap = sqlMap;
    }

    public SqlMap getSqlMap() {
        return this.sqlMap;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.sqlMap == null) {
            throw new IllegalArgumentException("sqlMap is required");
        }
    }

    public Object execute(String statementName, SqlMapCallback action) throws DataAccessException {
        MappedStatement stmt = this.sqlMap.getMappedStatement(statementName);
        Connection con = DataSourceUtils.getConnection((DataSource)this.getDataSource());
        try {
            Object object = action.doInMappedStatement(stmt, con);
            return object;
        }
        catch (SQLException ex) {
            throw this.getExceptionTranslator().translate("SqlMapTemplate", "(mapped statement)", ex);
        }
        finally {
            DataSourceUtils.closeConnectionIfNecessary((Connection)con, (DataSource)this.getDataSource());
        }
    }

    public List executeWithListResult(String statementName, SqlMapCallback action) throws DataAccessException {
        return (List)this.execute(statementName, action);
    }

    public Map executeWithMapResult(String statementName, SqlMapCallback action) throws DataAccessException {
        return (Map)this.execute(statementName, action);
    }

    public Object executeQueryForObject(String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return stmt.executeQueryForObject(con, parameterObject);
            }
        });
    }

    public Object executeQueryForObject(String statementName, final Object parameterObject, final Object resultObject) throws DataAccessException {
        return this.execute(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return stmt.executeQueryForObject(con, parameterObject, resultObject);
            }
        });
    }

    public List executeQueryForList(String statementName, final Object parameterObject) throws DataAccessException {
        return this.executeWithListResult(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return stmt.executeQueryForList(con, parameterObject);
            }
        });
    }

    public List executeQueryForList(String statementName, final Object parameterObject, final int skipResults, final int maxResults) throws DataAccessException {
        return this.executeWithListResult(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return stmt.executeQueryForList(con, parameterObject, skipResults, maxResults);
            }
        });
    }

    public Map executeQueryForMap(String statementName, final Object parameterObject, final String keyProperty) throws DataAccessException {
        return this.executeWithMapResult(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return stmt.executeQueryForMap(con, parameterObject, keyProperty);
            }
        });
    }

    public Map executeQueryForMap(String statementName, final Object parameterObject, final String keyProperty, final String valueProperty) throws DataAccessException {
        return this.executeWithMapResult(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return stmt.executeQueryForMap(con, parameterObject, keyProperty, valueProperty);
            }
        });
    }

    public void executeQueryWithRowHandler(String statementName, final Object parameterObject, final RowHandler rowHandler) throws DataAccessException {
        this.execute(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                stmt.executeQueryWithRowHandler(con, parameterObject, rowHandler);
                return null;
            }
        });
    }

    public int executeUpdate(String statementName, final Object parameterObject) throws DataAccessException {
        Integer result = (Integer)this.execute(statementName, new SqlMapCallback(){

            public Object doInMappedStatement(MappedStatement stmt, Connection con) throws SQLException {
                return new Integer(stmt.executeUpdate(con, parameterObject));
            }
        });
        return result;
    }
}

