/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;

public class ChildBeanDefinition
extends AbstractBeanDefinition {
    private String parentName;

    public ChildBeanDefinition(String parentName, PropertyValues pvs) {
        super(pvs);
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void validate() throws BeanDefinitionValidationException {
        super.validate();
        if (this.parentName == null) {
            throw new BeanDefinitionValidationException("parentName must be set in ChildBeanDefinition");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChildBeanDefinition)) {
            return false;
        }
        return super.equals(obj) && ((ChildBeanDefinition)obj).getParentName().equals(this.getParentName());
    }

    public String toString() {
        return "Child bean definition with parent '" + this.getParentName() + "'";
    }
}

