/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;

public class CollectionFactory {
    private static final String COMMONS_COLLECTIONS_CLASS_NAME = "org.apache.commons.collections.map.LinkedMap";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$core$CollectionFactory == null ? (class$org$springframework$core$CollectionFactory = CollectionFactory.class$("org.springframework.core.CollectionFactory")) : class$org$springframework$core$CollectionFactory));
    private static boolean commonsCollections3xAvailable;
    static /* synthetic */ Class class$org$springframework$core$CollectionFactory;

    public static Map createLinkedMapIfPossible(int initialCapacity) {
        if (JdkVersion.getMajorJavaVersion() >= 1) {
            logger.debug((Object)"Creating java.util.LinkedHashMap");
            return Jdk14CollectionFactory.createLinkedHashMap(initialCapacity);
        }
        if (commonsCollections3xAvailable) {
            logger.debug((Object)"Creating org.apache.commons.collections.map.LinkedMap;");
            return CommonsCollectionFactory.createCommonsLinkedMap(initialCapacity);
        }
        logger.debug((Object)"Falling back to java.util.HashMap for linked map");
        return new HashMap(initialCapacity);
    }

    public static Map createIdentityMapIfPossible(int initialCapacity) {
        if (JdkVersion.getMajorJavaVersion() >= 1) {
            logger.debug((Object)"Creating java.util.IdentityHashMap");
            return Jdk14CollectionFactory.createIdentityHashMap(initialCapacity);
        }
        if (commonsCollections3xAvailable) {
            logger.debug((Object)"Creating org.apache.commons.collections.map.IdentityMap;");
            return CommonsCollectionFactory.createCommonsIdentityMap(initialCapacity);
        }
        logger.debug((Object)"Falling back to java.util.HashMap for identity map");
        return new HashMap(initialCapacity);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (JdkVersion.getMajorJavaVersion() >= 1) {
            logger.info((Object)"Using JDK 1.4 collections");
        } else {
            try {
                Class.forName(COMMONS_COLLECTIONS_CLASS_NAME);
                commonsCollections3xAvailable = true;
                logger.info((Object)"Using Commons Collections 3.x");
            }
            catch (ClassNotFoundException ex) {
                commonsCollections3xAvailable = false;
                logger.info((Object)"Using JDK 1.3 collections");
            }
        }
    }

    private static abstract class CommonsCollectionFactory {
        private CommonsCollectionFactory() {
        }

        private static Map createCommonsLinkedMap(int initialCapacity) {
            return new LinkedMap(initialCapacity);
        }

        private static Map createCommonsIdentityMap(int initialCapacity) {
            return new IdentityMap(initialCapacity);
        }
    }

    private static abstract class Jdk14CollectionFactory {
        private Jdk14CollectionFactory() {
        }

        private static Map createLinkedHashMap(int initialCapacity) {
            return new LinkedHashMap(initialCapacity);
        }

        private static Map createIdentityHashMap(int initialCapacity) {
            return new IdentityHashMap(initialCapacity);
        }
    }
}

