/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.aop.target.AbstractPoolingTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;

public class CommonsPoolTargetSource
extends AbstractPoolingTargetSource
implements PoolableObjectFactory {
    private ObjectPool pool;

    protected final void createPool(BeanFactory beanFactory) {
        this.logger.info((Object)"Creating Commons object pool");
        this.pool = this.createObjectPool();
    }

    protected ObjectPool createObjectPool() {
        GenericObjectPool gop = new GenericObjectPool((PoolableObjectFactory)this);
        gop.setMaxActive(this.getMaxSize());
        return gop;
    }

    public Object getTarget() throws Exception {
        return this.pool.borrowObject();
    }

    public void releaseTarget(Object target) throws Exception {
        this.pool.returnObject(target);
    }

    public int getActive() {
        return this.pool.getNumActive();
    }

    public int getFree() {
        return this.pool.getNumIdle();
    }

    public void destroy() throws Exception {
        this.logger.info((Object)"Closing Commons pool");
        this.pool.close();
    }

    public Object makeObject() {
        return this.newPrototypeInstance();
    }

    public void destroyObject(Object o) throws Exception {
        if (o instanceof DisposableBean) {
            ((DisposableBean)o).destroy();
        }
    }

    public boolean validateObject(Object o) {
        return true;
    }

    public void activateObject(Object o) throws Exception {
    }

    public void passivateObject(Object o) throws Exception {
    }
}

