/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.InterceptionIntroductionAdvisor;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;

public class DefaultInterceptionIntroductionAdvisor
implements InterceptionIntroductionAdvisor,
ClassFilter {
    private IntroductionInterceptor interceptor;
    private Set interfaces = new HashSet();

    public DefaultInterceptionIntroductionAdvisor(IntroductionInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public DefaultInterceptionIntroductionAdvisor(IntroductionInterceptor interceptor, Class clazz) throws AopConfigException {
        this(interceptor);
        this.addInterface(clazz);
    }

    public DefaultInterceptionIntroductionAdvisor(DelegatingIntroductionInterceptor dii) {
        this((IntroductionInterceptor)dii);
        for (int i = 0; i < dii.getIntroducedInterfaces().length; ++i) {
            Class intf = dii.getIntroducedInterfaces()[i];
            this.addInterface(intf);
        }
    }

    public void addInterface(Class intf) throws AopConfigException {
        this.interfaces.add(intf);
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public IntroductionInterceptor getIntroductionInterceptor() {
        return this.interceptor;
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void validateInterfaces() throws AopConfigException {
        for (int i = 0; i < this.getInterfaces().length; ++i) {
            if (!this.getInterfaces()[i].isInterface()) {
                throw new AopConfigException("Class '" + this.getInterfaces()[i].getName() + "' is not an interface; cannot be used in an introduction");
            }
            if (this.getIntroductionInterceptor().implementsInterface(this.getInterfaces()[i])) continue;
            throw new AopConfigException("IntroductionInterceptor [" + this.getIntroductionInterceptor() + "] " + "does not implement interface '" + this.getInterfaces()[i].getName() + "' specified in introduction advice");
        }
    }
}

