/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.support.AopUtils;

public class ProxyFactory
extends AdvisedSupport {
    public ProxyFactory() {
    }

    public ProxyFactory(Object target) throws AopConfigException {
        if (target == null) {
            throw new AopConfigException("Can't proxy null object");
        }
        this.setInterfaces(AopUtils.getAllInterfaces(target));
        this.setTarget(target);
    }

    public ProxyFactory(Class[] interfaces) {
        this.setInterfaces(interfaces);
    }

    public Object getProxy() {
        AopProxy proxy = this.createAopProxy();
        return proxy.getProxy();
    }

    public static Object getProxy(Class proxyInterface, Interceptor interceptor) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(proxyInterface);
        proxyFactory.addInterceptor(interceptor);
        return proxyFactory.getProxy();
    }
}

