/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.util;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class BlackboardMap {
    private final Map<String, Key<Object>> keys = new ConcurrentHashMap<String, Key<Object>>();
    private final Map<Key<Object>, Object> values = new ConcurrentHashMap<Key<Object>, Object>();

    @NotNull
    public static BlackboardMap create() {
        return new BlackboardMap();
    }

    private BlackboardMap() {
    }

    @NotNull
    public <V> Optional<V> get(@NotNull Key<V> key) {
        Objects.requireNonNull(key, "key");
        return Optional.ofNullable(key.type().cast(this.values.get(key)));
    }

    public <V> void put(@NotNull Key<V> key, @Nullable V value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            return;
        }
        if (Objects.equals(key.defaultValue(), value)) {
            this.values.remove(key);
        } else {
            this.put(this.values, key, value);
        }
    }

    private <C1, C2, V> void put(@NotNull Map<C1, C2> map, @NotNull Key<V> key, @NotNull V value) {
        map.put(key, value);
    }

    @NotNull
    private Map<String, Key<Object>> keys() {
        return this.keys;
    }

    public static final class Key<T>
    implements Comparable<Key<T>> {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long identifier = ID_GENERATOR.getAndIncrement();
        private final String name;
        private final Class<T> type;
        private final T defaultValue;

        @NotNull
        public static <V> Key<V> of(@NotNull BlackboardMap map, @NotNull String name, @NotNull Class<? super V> type, @UnknownNullability V defaultValue) {
            Key result = map.keys().computeIfAbsent(name, key -> new Key<Object>((String)key, type, defaultValue));
            if (result.type != type) {
                throw new IllegalArgumentException("Mismatched type!");
            }
            return result;
        }

        private Key(@NotNull String name, @NotNull Class<T> type, @UnknownNullability T defaultValue) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public Class<T> type() {
            return this.type;
        }

        public @UnknownNullability T defaultValue() {
            return this.defaultValue;
        }

        public int hashCode() {
            return (int)(this.identifier ^ this.identifier >>> 32);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key that = (Key)other;
            return Objects.equals(this.identifier, that.identifier);
        }

        public String toString() {
            return "Key{identifier=" + this.identifier + ", name=" + this.name + ", type=" + this.type + "}";
        }

        @Override
        public int compareTo(@NotNull Key<T> other) {
            if (this == other) {
                return 0;
            }
            if (this.identifier < other.identifier) {
                return -1;
            }
            if (this.identifier > other.identifier) {
                return 1;
            }
            throw new RuntimeException("Unable to compare the given key!");
        }
    }
}

