/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.mod;

import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.ignite.api.mod.ModConfig;
import space.vectrix.ignite.api.mod.ModResource;

public final class ModContainer {
    private final Logger logger;
    private final ModResource resource;
    private final ModConfig config;

    public ModContainer(@NonNull Logger logger, @NonNull ModResource resource, @NonNull ModConfig config) {
        this.logger = logger;
        this.resource = resource;
        this.config = config;
    }

    public final @NonNull Logger getLogger() {
        return this.logger;
    }

    public final @NonNull String getId() {
        return this.config.getId();
    }

    public final @NonNull String getVersion() {
        return this.config.getVersion();
    }

    public final @NonNull ModResource getResource() {
        return this.resource;
    }

    public final @NonNull ModConfig getConfig() {
        return this.config;
    }

    public final int hashCode() {
        return Objects.hash(this.resource, this.config);
    }

    public final boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModContainer)) {
            return false;
        }
        ModContainer that = (ModContainer)other;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.config, that.config);
    }

    public final @NonNull String toString() {
        return this.getId() + "@" + this.getVersion();
    }
}

