/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import space.vectrix.ignite.api.config.Configuration;

public final class Configurations {
    public static final @NonNull Function<Configuration.Key<?>, ConfigurationLoader<BasicConfigurationNode>> GSON_LOADER = key -> Configurations.createLoader(key, path -> ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().source(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).sink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, SINK_OPTIONS))).defaultOptions(options -> options.shouldCopyDefaults(true))).build());
    public static final @NonNull Function<Configuration.Key<?>, ConfigurationLoader<CommentedConfigurationNode>> HOCON_LOADER = key -> Configurations.createLoader(key, path -> ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().source(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).sink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, SINK_OPTIONS))).defaultOptions(options -> options.shouldCopyDefaults(true))).build());
    public static final @NonNull Function<Configuration.Key<?>, ConfigurationLoader<CommentedConfigurationNode>> YAML_LOADER = key -> Configurations.createLoader(key, path -> ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().source(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).sink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, SINK_OPTIONS))).defaultOptions(options -> options.shouldCopyDefaults(true))).build());
    private static final ConcurrentMap<Configuration.Key<?>, Configuration<?, ?>> CONFIGURATIONS = new ConcurrentHashMap();
    private static final OpenOption[] SINK_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.DSYNC};

    public static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> getOrCreate(@NonNull ConfigurationLoader<N> loader, @NonNull Configuration.Key<T> key) {
        return Configurations.loadConfiguration(ignored -> loader, key);
    }

    public static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> getOrCreate(@NonNull Function<Configuration.Key<?>, ConfigurationLoader<N>> loaderSupplier, @NonNull Configuration.Key<T> key) {
        return Configurations.loadConfiguration(loaderSupplier, key);
    }

    private static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> loadConfiguration(@NonNull Function<Configuration.Key<?>, ConfigurationLoader<N>> loaderSupplier, @NonNull Configuration.Key<T> key) {
        return CONFIGURATIONS.computeIfAbsent(key, ignored -> {
            try {
                Configuration configuration = new Configuration(key, (ConfigurationLoader)loaderSupplier.apply(key));
                configuration.load();
                return configuration;
            }
            catch (ConfigurateException exception) {
                throw new AssertionError("Unable to load configuration.", exception);
            }
        });
    }

    private static <T, N extends ScopedConfigurationNode<N>, L extends AbstractConfigurationLoader<N>> L createLoader(@NonNull Configuration.Key<T> key, @NonNull Function<Path, L> loader) {
        Path path = key.path();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return (L)((AbstractConfigurationLoader)loader.apply(path));
        }
        catch (IOException exception) {
            throw new AssertionError("Unable to create configuration directory.", exception);
        }
    }
}

