/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.mod;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ModConfig {
    private String id;
    private String version;
    private String target;
    private List<String> requiredDependencies;
    private List<String> optionalDependencies;
    private List<String> mixins;

    public ModConfig() {
    }

    public ModConfig(@NonNull String id, @NonNull String version) {
        this.id = id;
        this.version = version;
    }

    public ModConfig(@NonNull String id, @NonNull String version, @Nullable String target, @Nullable List<String> requiredDependencies, @Nullable List<String> optionalDependencies, @Nullable List<String> mixins) {
        this.id = id;
        this.version = version;
        this.target = target;
        this.requiredDependencies = requiredDependencies;
        this.optionalDependencies = optionalDependencies;
        this.mixins = mixins;
    }

    public final @MonotonicNonNull String getId() {
        return this.id;
    }

    public final @MonotonicNonNull String getVersion() {
        return this.version;
    }

    public final @Nullable String getTarget() {
        return this.target;
    }

    public final @Nullable List<String> getRequiredDependencies() {
        return this.requiredDependencies;
    }

    public final @Nullable List<String> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public final @Nullable List<String> getMixins() {
        return this.mixins;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.version, this.target, this.requiredDependencies, this.optionalDependencies, this.mixins);
    }

    public final boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModConfig)) {
            return false;
        }
        ModConfig that = (ModConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.target, that.target) && Objects.deepEquals(this.requiredDependencies, that.requiredDependencies) && Objects.deepEquals(this.optionalDependencies, that.optionalDependencies) && Objects.deepEquals(this.mixins, that.mixins);
    }

    public final @NonNull String toString() {
        return "ModConfig{id=" + this.id + ", version=" + this.version + ", target=" + this.target + ", requiredDependencies=" + (this.requiredDependencies != null ? Arrays.toString(this.requiredDependencies.toArray(new String[0])) : "[]") + ", optionalDependencies=" + (this.optionalDependencies != null ? Arrays.toString(this.optionalDependencies.toArray(new String[0])) : "[]") + ", mixins=" + (this.mixins != null ? Arrays.toString(this.mixins.toArray(new String[0])) : "[]") + "}";
    }
}

