/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SM3Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SM3Serializer.class)
public final class SM3 {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("SM3"));
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;
    private final int i7;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SM3");
    }

    public SM3(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
        this.i5 = SharedUtil.AVH.get(arr, off + 20);
        this.i6 = SharedUtil.AVH.get(arr, off + 24);
        this.i7 = SharedUtil.AVH.get(arr, off + 28);
    }

    public SM3(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public SM3(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        SharedUtil.AVH.set(arr, off + 20, this.i5);
        SharedUtil.AVH.set(arr, off + 24, this.i6);
        SharedUtil.AVH.set(arr, off + 28, this.i7);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[32], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SM3 t = (SM3)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6 && this.i7 == t.i7;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7);
    }

    @NotNull
    public static SM3 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SM3.getThreadLocalDigest(), inputStream, SM3::new);
    }

    @NotNull
    public static SM3 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SM3.getThreadLocalDigest(), channel, SM3::new);
    }

    @NotNull
    public static SM3 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SM3.getThreadLocalDigest(), path, SM3::new);
    }

    @NotNull
    public static SM3 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SM3.getThreadLocalDigest(), data, off, len, SM3::new);
    }

    @NotNull
    public static SM3 of(byte @NotNull [] data) {
        return SM3.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SM3> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SM3.newDigest(), inputStream, SM3::new);
    }
}

