/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import java.util.Arrays;
import java.util.List;
import software.xdev.mockserver.model.Cookie;
import software.xdev.mockserver.serialization.java.MultiValueToJavaSerializer;
import software.xdev.mockserver.serialization.java.NottableStringToJavaSerializer;

public class CookieToJavaSerializer
implements MultiValueToJavaSerializer<Cookie> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Cookie cookie) {
        return "\n" + " ".repeat(numberOfSpacesToIndent * 8) + "new Cookie(" + NottableStringToJavaSerializer.serialize(cookie.getName(), false) + ", " + NottableStringToJavaSerializer.serialize(cookie.getValue(), false) + ")";
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Cookie> cookies) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < cookies.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, cookies.get(i)));
            if (i >= cookies.size() - 1) continue;
            output.append(',');
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Cookie ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

