/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.unification;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.codec.LimitedHttpContentDecompressor;
import software.xdev.mockserver.codec.MockServerHttpServerCodec;
import software.xdev.mockserver.codec.PreserveHeadersNettyRemoves;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.lifecycle.LifeCycle;
import software.xdev.mockserver.logging.LoggingHandler;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.netty.HttpRequestHandler;
import software.xdev.mockserver.netty.proxy.BinaryRequestProxyingHandler;
import software.xdev.mockserver.netty.proxy.socks.Socks4ProxyHandler;
import software.xdev.mockserver.netty.proxy.socks.Socks5ProxyHandler;
import software.xdev.mockserver.netty.proxy.socks.SocksDetector;
import software.xdev.mockserver.netty.unification.HttpContentLengthRemover;
import software.xdev.mockserver.netty.unification.PortBinding;
import software.xdev.mockserver.netty.websocketregistry.CallbackWebSocketServerHandler;
import software.xdev.mockserver.util.StringUtils;

public class PortUnificationHandler
extends ReplayingDecoder<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(PortUnificationHandler.class);
    private static final AttributeKey<Boolean> TLS_ENABLED_UPSTREAM = AttributeKey.valueOf((String)"TLS_ENABLED_UPSTREAM");
    private static final AttributeKey<Boolean> HTTP_ENABLED = AttributeKey.valueOf((String)"HTTP_ENABLED");
    private static final Map<PortBinding, Set<String>> LOCAL_ADDRESSES_CACHE = new ConcurrentHashMap<PortBinding, Set<String>>();
    private final LoggingHandler loggingHandler = new LoggingHandler(PortUnificationHandler.class.getName() + "-first");
    private final HttpContentLengthRemover httpContentLengthRemover = new HttpContentLengthRemover();
    private final PreserveHeadersNettyRemoves preserveHeadersNettyRemoves = new PreserveHeadersNettyRemoves();
    private final ServerConfiguration configuration;
    private final LifeCycle server;
    private final HttpState httpState;
    private final HttpActionHandler actionHandler;

    public PortUnificationHandler(ServerConfiguration configuration, LifeCycle server, HttpState httpState, HttpActionHandler actionHandler) {
        this.configuration = configuration;
        this.server = server;
        this.httpState = httpState;
        this.actionHandler = actionHandler;
    }

    public static void enableSslUpstreamAndDownstream(Channel channel) {
        channel.attr(TLS_ENABLED_UPSTREAM).set((Object)Boolean.TRUE);
    }

    public static boolean isSslEnabledUpstream(Channel channel) {
        if (channel.attr(TLS_ENABLED_UPSTREAM).get() != null) {
            return (Boolean)channel.attr(TLS_ENABLED_UPSTREAM).get();
        }
        return false;
    }

    public static void httpEnabled(Channel channel) {
        channel.attr(HTTP_ENABLED).set((Object)Boolean.TRUE);
    }

    public static boolean isHttpEnabled(Channel channel) {
        if (channel.attr(HTTP_ENABLED).get() != null) {
            return (Boolean)channel.attr(HTTP_ENABLED).get();
        }
        return false;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        if (SocksDetector.isSocks4(msg, this.actualReadableBytes())) {
            this.logStage(ctx, "adding SOCKS4 decoders");
            this.enableSocks4(ctx, msg);
        } else if (SocksDetector.isSocks5(msg, this.actualReadableBytes())) {
            this.logStage(ctx, "adding SOCKS5 decoders");
            this.enableSocks5(ctx, msg);
        } else if (this.isTls(msg)) {
            this.logStage(ctx, "adding TLS decoders");
            this.enableTls(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.logStage(ctx, "adding HTTP decoders");
            this.switchToHttp(ctx, msg);
        } else if (this.isProxyConnected(msg)) {
            this.logStage(ctx, "setting proxy connected");
            this.switchToProxyConnected(ctx, msg);
        } else if (this.configuration.assumeAllRequestsAreHttp().booleanValue()) {
            this.logStage(ctx, "adding HTTP decoders");
            this.switchToHttp(ctx, msg);
        } else {
            this.logStage(ctx, "adding binary decoder");
            this.switchToBinaryRequestProxying(ctx, msg);
        }
        if (LOG.isTraceEnabled()) {
            this.loggingHandler.addLoggingHandler(ctx);
        }
    }

    private void logStage(ChannelHandlerContext ctx, String message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} for channel: {} pipeline: {}", new Object[]{message, ctx.channel().toString(), ctx.pipeline().names()});
        }
    }

    private void enableSocks4(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, (ReplayingDecoder<?>)new Socks4ServerDecoder(), new ChannelHandler[]{new Socks4ProxyHandler(this.configuration, this.server), Socks4ServerEncoder.INSTANCE});
    }

    private void enableSocks5(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, (ReplayingDecoder<?>)new Socks5InitialRequestDecoder(), new ChannelHandler[]{new Socks5ProxyHandler(this.configuration, this.server), Socks5ServerEncoder.DEFAULT});
    }

    private void enableSocks(ChannelHandlerContext ctx, ByteBuf msg, ReplayingDecoder<?> socksInitialRequestDecoder, ChannelHandler ... channelHandlers) {
        ChannelPipeline pipeline = ctx.pipeline();
        for (ChannelHandler channelHandler : channelHandlers) {
            if (PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
                pipeline.addAfter("SslHandler#0", null, channelHandler);
                continue;
            }
            pipeline.addFirst(new ChannelHandler[]{channelHandler});
        }
        pipeline.addFirst(new ChannelHandler[]{socksInitialRequestDecoder});
        HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
        ctx.pipeline().fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isTls(ByteBuf buf) {
        return SslHandler.isEncrypted((ByteBuf)buf, (boolean)false);
    }

    private void enableTls(ChannelHandlerContext ctx, ByteBuf msg) {
        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
        ctx.pipeline().fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private boolean isHttp(ByteBuf msg) {
        String method = msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII);
        return method.startsWith("GET ") || method.startsWith("POST ") || method.startsWith("PUT ") || method.startsWith("HEAD ") || method.startsWith("OPTIONS ") || method.startsWith("PATCH ") || method.startsWith("DELETE ") || method.startsWith("TRACE ") || method.startsWith("CONNECT ");
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        if (!PortUnificationHandler.isHttpEnabled(ctx.channel())) {
            PortUnificationHandler.httpEnabled(ctx.channel());
            ChannelPipeline pipeline = ctx.pipeline();
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpServerCodec(this.configuration.maxInitialLineLength().intValue(), this.configuration.maxHeaderSize().intValue(), this.configuration.maxChunkSize().intValue()));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)this.preserveHeadersNettyRemoves);
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new LimitedHttpContentDecompressor());
            this.addLastIfNotPresent(pipeline, (ChannelHandler)this.httpContentLengthRemover);
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new CallbackWebSocketServerHandler(this.httpState));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new MockServerHttpServerCodec(this.configuration, ctx.channel().localAddress()));
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpRequestHandler(this.configuration, this.server, this.httpState, this.actionHandler));
            pipeline.remove((ChannelHandler)this);
            ctx.channel().attr(HttpRequestHandler.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
            ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
        }
    }

    private boolean isProxyConnected(ByteBuf msg) {
        return msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII).startsWith("PROXIED_");
    }

    private void switchToProxyConnected(ChannelHandlerContext ctx, ByteBuf msg) {
        String message = this.readMessage(msg);
        if (message.startsWith("PROXIED_SECURE_")) {
            String[] hostParts = StringUtils.substringAfter((String)message, (String)"PROXIED_SECURE_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 443;
            PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
            HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
            HttpActionHandler.setRemoteAddress(ctx, new InetSocketAddress(hostParts[0], port));
        } else if (message.startsWith("PROXIED_")) {
            String[] hostParts = StringUtils.substringAfter((String)message, (String)"PROXIED_").split(":");
            int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : 80;
            HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
            HttpActionHandler.setRemoteAddress(ctx, new InetSocketAddress(hostParts[0], port));
        }
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])("PROXIED_RESPONSE_" + message).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
    }

    private String readMessage(ByteBuf msg) {
        byte[] bytes = new byte[this.actualReadableBytes()];
        msg.readBytes(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private void switchToBinaryRequestProxying(ChannelHandlerContext ctx, ByteBuf msg) {
        this.addLastIfNotPresent(ctx.pipeline(), (ChannelHandler)new BinaryRequestProxyingHandler(this.configuration, this.httpState.getScheduler(), this.actionHandler.getHttpClient(), this.httpState.getEventBus()));
        ctx.fireChannelRead((Object)msg.readBytes(this.actualReadableBytes()));
    }

    private Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        String portExtension;
        InetSocketAddress inetSocketAddress;
        PortBinding cacheKey;
        SocketAddress localAddress = ctx.channel().localAddress();
        Set<String> localAddresses = null;
        if (localAddress instanceof InetSocketAddress && (localAddresses = LOCAL_ADDRESSES_CACHE.get((Object)(cacheKey = new PortBinding(inetSocketAddress = (InetSocketAddress)localAddress, portExtension = this.calculatePortExtension(inetSocketAddress, PortUnificationHandler.isSslEnabledUpstream(ctx.channel())))))) == null) {
            localAddresses = this.calculateLocalAddresses(inetSocketAddress, portExtension);
            LOCAL_ADDRESSES_CACHE.put(cacheKey, localAddresses);
        }
        return localAddresses == null ? Collections.emptySet() : localAddresses;
    }

    private String calculatePortExtension(InetSocketAddress inetSocketAddress, boolean sslEnabledUpstream) {
        Object portExtension = inetSocketAddress.getPort() == 443 && sslEnabledUpstream || inetSocketAddress.getPort() == 80 && !sslEnabledUpstream ? "" : ":" + inetSocketAddress.getPort();
        return portExtension;
    }

    private Set<String> calculateLocalAddresses(InetSocketAddress localAddress, String portExtension) {
        InetAddress socketAddress = localAddress.getAddress();
        HashSet<CallSite> localAddresses = new HashSet<CallSite>();
        localAddresses.add((CallSite)((Object)(socketAddress.getHostAddress() + portExtension)));
        localAddresses.add((CallSite)((Object)(socketAddress.getCanonicalHostName() + portExtension)));
        localAddresses.add((CallSite)((Object)(socketAddress.getHostName() + portExtension)));
        localAddresses.add((CallSite)((Object)("localhost" + portExtension)));
        localAddresses.add((CallSite)((Object)("127.0.0.1" + portExtension)));
        return Collections.unmodifiableSet(localAddresses);
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(new ChannelHandler[]{channelHandler});
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        if (ExceptionHandling.connectionClosedException(throwable)) {
            LOG.error("Exception caught by port unification handler -> closing pipeline {}", (Object)ctx.channel(), (Object)throwable);
        } else if (ExceptionHandling.sslHandshakeException(throwable)) {
            if (throwable.getMessage().contains("certificate_unknown") || throwable.getMessage().toLowerCase().contains("unknown_ca")) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("TLS handshake failure: Client does not trust MockServer Certificate Authority for: {} See http://mock-server.com/mock_server/HTTPS_TLS.html to enable the client to trust MocksServer Certificate Authority.", (Object)ctx.channel(), (Object)throwable);
                }
            } else if (!throwable.getMessage().contains("close_notify during handshake")) {
                LOG.error("TLS handshake failure while a client attempted to connect to {}", (Object)ctx.channel(), (Object)throwable);
            }
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

