/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.proxy.relay;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.codec.LimitedHttpContentDecompressor;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.lifecycle.LifeCycle;
import software.xdev.mockserver.logging.LoggingHandler;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.netty.proxy.relay.DownstreamProxyRelayHandler;
import software.xdev.mockserver.netty.proxy.relay.UpstreamProxyRelayHandler;
import software.xdev.mockserver.netty.unification.PortUnificationHandler;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RelayConnectHandler.class);
    public static final String PROXIED = "PROXIED_";
    public static final String PROXIED_SECURE = "PROXIED_SECURE_";
    public static final String PROXIED_RESPONSE = "PROXIED_RESPONSE_";
    private final ServerConfiguration configuration;
    private final LifeCycle server;
    protected final String host;
    protected final int port;

    protected RelayConnectHandler(ServerConfiguration configuration, LifeCycle server, String host, int port) {
        this.configuration = configuration;
        this.server = server;
        this.host = host;
        this.port = port;
    }

    public void channelRead0(final ChannelHandlerContext proxyClientCtx, final T request) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)proxyClientCtx.channel().eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext mockServerCtx) {
                if (PortUnificationHandler.isSslEnabledUpstream(proxyClientCtx.channel())) {
                    mockServerCtx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])(RelayConnectHandler.PROXIED_SECURE + RelayConnectHandler.this.host + ":" + RelayConnectHandler.this.port).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
                } else {
                    mockServerCtx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])(RelayConnectHandler.PROXIED + RelayConnectHandler.this.host + ":" + RelayConnectHandler.this.port).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
                }
            }

            public void channelRead(ChannelHandlerContext mockServerCtx, Object msg) {
                if (msg instanceof ByteBuf) {
                    ByteBuf byteBuf = (ByteBuf)msg;
                    byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
                    if (new String(bytes, StandardCharsets.UTF_8).startsWith(RelayConnectHandler.PROXIED_RESPONSE)) {
                        proxyClientCtx.writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                            RelayConnectHandler.this.removeCodecSupport(proxyClientCtx);
                            ChannelPipeline pipelineToMockServer = mockServerCtx.channel().pipeline();
                            if (LOG.isTraceEnabled()) {
                                pipelineToMockServer.addLast(new ChannelHandler[]{new LoggingHandler(RelayConnectHandler.class.getName() + "-downstream -->")});
                            }
                            pipelineToMockServer.addLast(new ChannelHandler[]{new HttpClientCodec(RelayConnectHandler.this.configuration.maxInitialLineLength().intValue(), RelayConnectHandler.this.configuration.maxHeaderSize().intValue(), RelayConnectHandler.this.configuration.maxChunkSize().intValue())});
                            pipelineToMockServer.addLast(new ChannelHandler[]{new LimitedHttpContentDecompressor()});
                            pipelineToMockServer.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                            pipelineToMockServer.addLast(new ChannelHandler[]{new DownstreamProxyRelayHandler(proxyClientCtx.channel())});
                            ChannelPipeline pipelineToProxyClient = proxyClientCtx.channel().pipeline();
                            if (LOG.isTraceEnabled()) {
                                pipelineToProxyClient.addLast(new ChannelHandler[]{new LoggingHandler(RelayConnectHandler.class.getName() + "-upstream <-- ")});
                            }
                            pipelineToProxyClient.addLast(new ChannelHandler[]{new HttpServerCodec(RelayConnectHandler.this.configuration.maxInitialLineLength().intValue(), RelayConnectHandler.this.configuration.maxHeaderSize().intValue(), RelayConnectHandler.this.configuration.maxChunkSize().intValue())});
                            pipelineToProxyClient.addLast(new ChannelHandler[]{new LimitedHttpContentDecompressor()});
                            pipelineToProxyClient.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                            pipelineToProxyClient.addLast(new ChannelHandler[]{new UpstreamProxyRelayHandler(mockServerCtx.channel())});
                        }));
                    } else {
                        mockServerCtx.fireChannelRead(msg);
                    }
                }
            }
        });
        InetSocketAddress remoteSocket = this.getDownstreamSocket(proxyClientCtx);
        bootstrap.connect((SocketAddress)remoteSocket).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.failure("Connection failed to " + String.valueOf(remoteSocket), future.cause(), proxyClientCtx, this.failureResponse(request));
            }
        }));
    }

    private InetSocketAddress getDownstreamSocket(ChannelHandlerContext ctx) {
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
        if (remoteAddress != null) {
            return remoteAddress;
        }
        return new InetSocketAddress(this.server.getLocalPort());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failure("Exception caught by CONNECT proxy handler -> closing pipeline ", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            LOG.error(message, cause);
        }
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);

    protected void removeHandler(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerType) {
        if (pipeline.get(handlerType) != null) {
            pipeline.remove(handlerType);
        }
    }

    protected void removeHandler(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.toMap().containsValue(channelHandler)) {
            pipeline.remove(channelHandler);
        }
    }
}

