/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.event.EventBus;
import software.xdev.mockserver.event.model.EventEntry;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.formatting.StringFormatter;
import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.model.BinaryMessage;
import software.xdev.mockserver.model.BinaryProxyListener;
import software.xdev.mockserver.netty.unification.PortUnificationHandler;
import software.xdev.mockserver.scheduler.Scheduler;
import software.xdev.mockserver.uuid.UUIDService;

@ChannelHandler.Sharable
public class BinaryRequestProxyingHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryRequestProxyingHandler.class);
    private final ServerConfiguration configuration;
    private final Scheduler scheduler;
    private final NettyHttpClient httpClient;
    private final BinaryProxyListener binaryExchangeCallback;
    private final EventBus eventBus;

    public BinaryRequestProxyingHandler(ServerConfiguration configuration, Scheduler scheduler, NettyHttpClient httpClient, EventBus eventBus) {
        super(true);
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.httpClient = httpClient;
        this.binaryExchangeCallback = configuration.binaryProxyListener();
        this.eventBus = eventBus;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
        this.eventBus.add(new EventEntry().setType(EventEntry.EventType.RECEIVED_REQUEST).setCorrelationId(UUIDService.getUUID()));
        BinaryMessage binaryRequest = BinaryMessage.bytes((byte[])ByteBufUtil.getBytes((ByteBuf)byteBuf));
        LOG.info("Received binary request: {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()));
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
        if (remoteAddress != null) {
            this.sendMessage(ctx, binaryRequest, remoteAddress);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP, found request in binary: {} in utf8 text: {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), (Object)new String(binaryRequest.getBytes(), StandardCharsets.UTF_8));
            }
            ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])"unknown message format, only HTTP requests are supported for mocking or HTTP & binary requests for proxying, but request is not being proxied and request is not valid HTTP".getBytes(StandardCharsets.UTF_8)));
            ctx.close();
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, BinaryMessage binaryRequest, InetSocketAddress remoteAddress) {
        CompletableFuture binaryResponseFuture = this.httpClient.sendRequest(binaryRequest, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()), remoteAddress, this.configuration.socketConnectionTimeoutInMillis());
        if (this.configuration.forwardBinaryRequestsWithoutWaitingForResponse().booleanValue()) {
            this.processNotWaitingForResponse(ctx, binaryRequest, remoteAddress, binaryResponseFuture);
        } else {
            this.processWaitingForResponse(ctx, binaryRequest, remoteAddress, binaryResponseFuture);
        }
    }

    private void processNotWaitingForResponse(ChannelHandlerContext ctx, BinaryMessage binaryRequest, InetSocketAddress remoteAddress, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        if (this.binaryExchangeCallback != null) {
            this.binaryExchangeCallback.onProxy(binaryRequest, binaryResponseFuture, (SocketAddress)remoteAddress, ctx.channel().remoteAddress());
        }
        this.scheduler.submit(binaryResponseFuture, () -> {
            try {
                BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                if (binaryResponse != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Returning binary response: {} from: {} for forwarded binary request: {}", new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())});
                    }
                    ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
                }
            }
            catch (Exception ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Exception whilst sending hex {} to {} closing connection", new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress, ex});
                }
                ctx.close();
            }
        }, false);
    }

    private void processWaitingForResponse(ChannelHandlerContext ctx, BinaryMessage binaryRequest, InetSocketAddress remoteAddress, CompletableFuture<BinaryMessage> binaryResponseFuture) {
        this.scheduler.submit(binaryResponseFuture, () -> {
            try {
                BinaryMessage binaryResponse = (BinaryMessage)binaryResponseFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Returning binary response: {} from: {} for forwarded binary request: {}", new Object[]{StringFormatter.formatBytes((byte[])binaryResponse.getBytes()), remoteAddress, StringFormatter.formatBytes((byte[])binaryRequest.getBytes())});
                }
                if (this.binaryExchangeCallback != null) {
                    this.binaryExchangeCallback.onProxy(binaryRequest, binaryResponseFuture, (SocketAddress)remoteAddress, ctx.channel().remoteAddress());
                }
                ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryResponse.getBytes()));
            }
            catch (Exception ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Exception whilst sending hex {} to {} closing connection", new Object[]{ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), remoteAddress, ex});
                }
                ctx.close();
            }
        }, false);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            LOG.error("Exception caught by {} handler -> closing pipeline {}", new Object[]{((Object)((Object)this)).getClass(), ctx.channel(), cause});
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

