/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.action.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import software.xdev.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.model.Action;
import software.xdev.mockserver.model.HttpObjectCallback;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.responsewriter.ResponseWriter;
import software.xdev.mockserver.uuid.UUIDService;

public class HttpResponseObjectCallbackActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseObjectCallbackActionHandler.class);
    private final WebSocketClientRegistry webSocketClientRegistry;

    public HttpResponseObjectCallbackActionHandler(HttpState httpStateHandler) {
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Runnable expectationPostProcessor) {
        String clientId = httpObjectCallback.getClientId();
        if (LocalCallbackRegistry.responseClientExists((String)clientId)) {
            this.handleLocally(actionHandler, httpObjectCallback, request, responseWriter, synchronous, clientId);
        } else {
            this.handleViaWebSocket(actionHandler, httpObjectCallback, request, responseWriter, synchronous, expectationPostProcessor, clientId);
        }
    }

    private void handleLocally(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, String clientId) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locally sending request {} to client {}", (Object)request, (Object)clientId);
        }
        try {
            HttpResponse callbackResponse = LocalCallbackRegistry.retrieveResponseCallback((String)clientId).handle(request);
            actionHandler.writeResponseActionResponse(callbackResponse, responseWriter, request, (Action)httpObjectCallback, synchronous);
        }
        catch (Exception ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Returning {} because client {} response callback throw an exception", new Object[]{HttpResponse.notFoundResponse(), clientId, ex});
            }
            actionHandler.writeResponseActionResponse(HttpResponse.notFoundResponse(), responseWriter, request, (Action)httpObjectCallback, synchronous);
        }
    }

    private void handleViaWebSocket(HttpActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Runnable expectationPostProcessor, String clientId) {
        String webSocketCorrelationId = UUIDService.getUUID();
        this.webSocketClientRegistry.registerResponseCallbackHandler(webSocketCorrelationId, response -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received response over websocket {} for request {} from client {} for correlationId {}", new Object[]{response, request, clientId, webSocketCorrelationId});
            }
            this.webSocketClientRegistry.unregisterResponseCallbackHandler(webSocketCorrelationId);
            if (expectationPostProcessor != null) {
                expectationPostProcessor.run();
            }
            actionHandler.writeResponseActionResponse(response.removeHeader("WebSocketCorrelationId"), responseWriter, request, (Action)httpObjectCallback, synchronous);
        });
        if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", new String[]{webSocketCorrelationId}), null)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Returning {} because client {} has closed web socket connection", (Object)HttpResponse.notFoundResponse(), (Object)clientId);
            }
            actionHandler.writeResponseActionResponse(HttpResponse.notFoundResponse(), responseWriter, request, (Action)httpObjectCallback, synchronous);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Sending request over websocket {} to client {} for correlationId {}", new Object[]{request, clientId, webSocketCorrelationId});
        }
    }
}

