/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;
import software.xdev.mockserver.collections.NottableStringHashMap;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.NotMatcher;
import software.xdev.mockserver.model.KeyAndValue;
import software.xdev.mockserver.model.KeysAndValues;

public class HashMapMatcher
extends NotMatcher<KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues>> {
    private final NottableStringHashMap matcher;
    private final KeysAndValues keysAndValues;
    private final boolean controlPlaneMatcher;
    private Boolean allKeysNotted;
    private Boolean allKeysOptional;

    HashMapMatcher(KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues> keysAndValues, boolean controlPlaneMatcher) {
        this.keysAndValues = keysAndValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysAndValues != null ? new NottableStringHashMap(this.controlPlaneMatcher, keysAndValues.getEntries()) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues> matched) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (matched == null || matched.isEmpty()) {
            if (this.allKeysNotted == null) {
                this.allKeysNotted = this.matcher.allKeysNotted();
            }
            if (this.allKeysOptional == null) {
                this.allKeysOptional = this.matcher.allKeysOptional();
            }
            result = this.allKeysNotted != false || this.allKeysOptional != false;
        } else {
            result = new NottableStringHashMap(this.controlPlaneMatcher, matched.getEntries()).containsAll(context, this.matcher);
        }
        if (!result && context != null) {
            context.addDifference("map subset match failed expected:{}found:{}failed because:{}", this.keysAndValues, matched != null ? matched : "none", matched != null ? "map is not a subset" : "none is not a subset");
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashMapMatcher)) {
            return false;
        }
        HashMapMatcher that = (HashMapMatcher)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.controlPlaneMatcher == that.controlPlaneMatcher && Objects.equals(this.matcher, that.matcher) && Objects.equals(this.keysAndValues, that.keysAndValues) && Objects.equals(this.allKeysNotted, that.allKeysNotted) && Objects.equals(this.allKeysOptional, that.allKeysOptional);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matcher, this.keysAndValues, this.controlPlaneMatcher, this.allKeysNotted, this.allKeysOptional);
    }
}

