/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.collections;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import software.xdev.mockserver.matchers.RegexStringMatcher;
import software.xdev.mockserver.model.NottableString;

public class ImmutableEntry
extends Pair<NottableString, NottableString>
implements Map.Entry<NottableString, NottableString> {
    private final RegexStringMatcher regexStringMatcher;
    private final NottableString key;
    private final NottableString value;

    public static ImmutableEntry entry(RegexStringMatcher regexStringMatcher, String key, String value) {
        return new ImmutableEntry(regexStringMatcher, key, value);
    }

    public static ImmutableEntry entry(RegexStringMatcher regexStringMatcher, NottableString key, NottableString value) {
        return new ImmutableEntry(regexStringMatcher, key, value);
    }

    ImmutableEntry(RegexStringMatcher regexStringMatcher, String key, String value) {
        this.regexStringMatcher = regexStringMatcher;
        this.key = NottableString.string((String)key);
        this.value = NottableString.string((String)value);
    }

    ImmutableEntry(RegexStringMatcher regexStringMatcher, NottableString key, NottableString value) {
        this.regexStringMatcher = regexStringMatcher;
        this.key = key;
        this.value = value;
    }

    public boolean isOptional() {
        return ((NottableString)this.getKey()).isOptional();
    }

    public boolean isNotted() {
        return ((NottableString)this.getKey()).isNot() && !((NottableString)this.getValue()).isNot();
    }

    public boolean isNotOptional() {
        return !this.isOptional();
    }

    public NottableString getLeft() {
        return this.key;
    }

    public NottableString getRight() {
        return this.value;
    }

    @Override
    public NottableString setValue(NottableString value) {
        throw new UnsupportedOperationException("ImmutableEntry is immutable");
    }

    public String toString() {
        return "(" + String.valueOf(this.key) + ": " + String.valueOf(this.value) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEntry that = (ImmutableEntry)o;
        return this.regexStringMatcher.matches(this.key, that.key) && this.regexStringMatcher.matches(this.value, that.value) || !this.regexStringMatcher.matches(this.key, that.key) && (this.key.isOptional() || that.key.isOptional());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public static <T> boolean listsEqual(List<T> matcher, List<T> matched) {
        boolean matches = false;
        if (matcher.size() == matched.size()) {
            HashSet<Integer> matchedIndexes = new HashSet<Integer>();
            HashSet<Integer> matcherIndexes = new HashSet<Integer>();
            for (int i = 0; i < matcher.size(); ++i) {
                T matcherItem = matcher.get(i);
                for (int j = 0; j < matched.size(); ++j) {
                    T matchedItem = matched.get(j);
                    if (matcherItem == null || !matcherItem.equals(matchedItem)) continue;
                    matchedIndexes.add(j);
                    matcherIndexes.add(i);
                }
            }
            matches = matchedIndexes.size() == matched.size() && matcherIndexes.size() == matcher.size();
        }
        return matches;
    }

    public static boolean listsEqualWithOptionals(RegexStringMatcher regexStringMatcher, List<ImmutableEntry> matcher, List<ImmutableEntry> matched) {
        HashSet<Integer> matchingMatchedIndexes = new HashSet<Integer>();
        HashSet<Integer> matchingMatcherIndexes = new HashSet<Integer>();
        HashSet<NottableString> matcherKeys = new HashSet<NottableString>();
        matcher.forEach(matcherItem -> matcherKeys.add((NottableString)matcherItem.getKey()));
        HashSet<NottableString> matchedKeys = new HashSet<NottableString>();
        matched.forEach(matchedItem -> matchedKeys.add((NottableString)matchedItem.getKey()));
        for (int i = 0; i < matcher.size(); ++i) {
            ImmutableEntry matcherItem2 = matcher.get(i);
            if (matcherItem2 == null) continue;
            for (int j = 0; j < matched.size(); ++j) {
                ImmutableEntry matchedItem2 = matched.get(j);
                if (matchedItem2 == null) continue;
                if (matcherItem2.equals(matchedItem2)) {
                    matchingMatchedIndexes.add(j);
                    matchingMatcherIndexes.add(i);
                    continue;
                }
                if (((NottableString)matcherItem2.getKey()).isOptional() && !ImmutableEntry.contains(regexStringMatcher, matchedKeys, (NottableString)matcherItem2.getKey())) {
                    matchingMatchedIndexes.add(j);
                    matchingMatcherIndexes.add(i);
                    continue;
                }
                if (!((NottableString)matchedItem2.getKey()).isOptional() || ImmutableEntry.contains(regexStringMatcher, matcherKeys, (NottableString)matchedItem2.getKey())) continue;
                matchingMatchedIndexes.add(j);
                matchingMatcherIndexes.add(i);
            }
        }
        return matchingMatchedIndexes.size() == matched.size() && matchingMatcherIndexes.size() == matcher.size();
    }

    private static boolean contains(RegexStringMatcher regexStringMatcher, Set<NottableString> matchedKeys, NottableString matcherItem) {
        for (NottableString matchedKey : matchedKeys) {
            if (!regexStringMatcher.matches(matchedKey, matcherItem)) continue;
            return true;
        }
        return false;
    }
}

