/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.codec;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.model.KeyToMultiValue;
import software.xdev.mockserver.model.NottableOptionalString;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameter;
import software.xdev.mockserver.model.ParameterStyle;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.util.StringUtils;

public class ExpandedParameterDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterDecoder.class);
    private static final Predicate<String> QUOTED_PARAMETER_VALUE_PRE_CHECK = s -> s.contains("\"") || s.contains("'");
    private static final Pattern QUOTED_PARAMETER_VALUE = Pattern.compile("^\\s*[\"']+(.*)[\"']+\\s*$");
    private static final Predicate<String> JSON_VALUE_PRE_CHECK = s -> s.contains("{") || s.contains("[");
    private static final Pattern JSON_VALUE = Pattern.compile("(?s)^\\s*[{\\[].*[}\\]]\\s*$");
    private final ServerConfiguration configuration;

    public ExpandedParameterDecoder(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Parameters retrieveFormParameters(String parameterString, boolean hasPath) {
        Parameters parameters = new Parameters(new Parameter[0]);
        HashMap parameterMap = new HashMap();
        if (StringUtils.isNotBlank((String)parameterString)) {
            try {
                hasPath = parameterString.startsWith("/") || parameterString.contains("?") || hasPath;
                parameterMap.putAll(new QueryStringDecoder(parameterString, HttpConstants.DEFAULT_CHARSET, hasPath, Integer.MAX_VALUE, this.configuration.useSemicolonAsQueryParameterSeparator() == false).parameters());
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Exception while parsing query string {}", (Object)parameterString, (Object)iae);
            }
        }
        return (Parameters)parameters.withEntries(parameterMap);
    }

    public Parameters retrieveQueryParameters(String parameterString, boolean hasPath) {
        if (StringUtils.isNotBlank((String)parameterString)) {
            String rawParameterString = parameterString.contains("?") ? StringUtils.substringAfter((String)parameterString, (String)"?") : parameterString;
            HashMap parameterMap = new HashMap();
            try {
                hasPath = parameterString.startsWith("/") || parameterString.contains("?") || hasPath;
                parameterMap.putAll(new QueryStringDecoder(parameterString, HttpConstants.DEFAULT_CHARSET, parameterString.contains("/") || hasPath, Integer.MAX_VALUE, true).parameters());
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Exception while parsing query string {}", (Object)parameterString, (Object)iae);
            }
            return ((Parameters)new Parameters(new Parameter[0]).withEntries(parameterMap)).withRawParameterString(rawParameterString);
        }
        return null;
    }

    public void splitParameters(Parameters matcher, Parameters matched) {
        if (matcher != null && matched != null) {
            for (Parameter matcherEntry : matcher.getEntries()) {
                if (matcherEntry.getName().getParameterStyle() == null || !matcherEntry.getName().getParameterStyle().isExploded()) continue;
                for (Parameter matchedEntry : matched.getEntries()) {
                    if (!matcherEntry.getName().getValue().equals(matchedEntry.getName().getValue()) && !matchedEntry.getName().getValue().matches(matcherEntry.getName().getValue())) continue;
                    matchedEntry.replaceValues(new ExpandedParameterDecoder(this.configuration).splitOnDelimiter(matcherEntry.getName().getParameterStyle(), matcherEntry.getName().getValue(), matchedEntry.getValues()));
                    matched.replaceEntry((KeyToMultiValue)matchedEntry);
                }
            }
        }
    }

    public List<NottableString> splitOnDelimiter(ParameterStyle style, String name, List<NottableString> values) {
        if (StringUtils.isNotBlank((String)style.getRegex())) {
            ArrayList<NottableString> splitValues = new ArrayList<NottableString>();
            for (NottableString value : values) {
                Matcher quotedValue;
                String actualValue = value.getValue();
                Matcher matcher = quotedValue = QUOTED_PARAMETER_VALUE_PRE_CHECK.test(actualValue) ? QUOTED_PARAMETER_VALUE.matcher(actualValue) : null;
                if (quotedValue != null && quotedValue.matches()) {
                    if (value.isOptional()) {
                        splitValues.add((NottableString)NottableOptionalString.optional((String)quotedValue.group(1), (Boolean)value.isNot()));
                        continue;
                    }
                    splitValues.add(NottableString.string((String)quotedValue.group(1), (Boolean)value.isNot()));
                    continue;
                }
                if (JSON_VALUE_PRE_CHECK.test(actualValue) && JSON_VALUE.matcher(actualValue).matches()) continue;
                for (String splitValue : actualValue.split(style.getRegex().replace("<name>", name))) {
                    if (value.isOptional()) {
                        splitValues.add((NottableString)NottableOptionalString.optional((String)splitValue, (Boolean)value.isNot()));
                        continue;
                    }
                    splitValues.add(NottableString.string((String)splitValue, (Boolean)value.isNot()));
                }
            }
            return splitValues;
        }
        return values;
    }
}

