/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.serialization.java.DelayToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class HttpClassCallbackToJavaSerializer
implements ToJavaSerializer<HttpClassCallback> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpClassCallback httpClassCallback) {
        StringBuilder output = new StringBuilder();
        if (httpClassCallback != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("callback()");
            if (httpClassCallback.getCallbackClass() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCallbackClass(\"").append(httpClassCallback.getCallbackClass()).append("\")");
            }
            if (httpClassCallback.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpClassCallback.getDelay())).append(')');
            }
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

