/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.exception.ExceptionHandling;

public class UpstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(UpstreamProxyRelayHandler.class);
    private final Channel downstreamChannel;

    public UpstreamProxyRelayHandler(Channel downstreamChannel) {
        super(false);
        this.downstreamChannel = downstreamChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        this.downstreamChannel.writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                ctx.channel().read();
            } else {
                if (this.isNotSocketClosedException(future.cause())) {
                    LOG.error("Exception while returning response for request \"{} {}\"", (Object)request.method(), (Object)request.uri());
                }
                future.channel().close();
            }
        }));
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandling.closeOnFlush(this.downstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            LOG.error("Exception caught by upstream relay handler -> closing pipeline {}", (Object)ctx.channel(), (Object)cause);
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

