/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.BindException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.lifecycle.LifeCycle;
import software.xdev.mockserver.mock.HttpState;
import software.xdev.mockserver.mock.action.http.HttpActionHandler;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;
import software.xdev.mockserver.model.MediaType;
import software.xdev.mockserver.model.PortBinding;
import software.xdev.mockserver.netty.proxy.connect.HttpConnectHandler;
import software.xdev.mockserver.netty.responsewriter.NettyResponseWriter;
import software.xdev.mockserver.netty.unification.PortUnificationHandler;
import software.xdev.mockserver.scheduler.SchedulerThreadFactory;
import software.xdev.mockserver.serialization.Base64Converter;
import software.xdev.mockserver.serialization.PortBindingSerializer;
import software.xdev.mockserver.util.StringUtils;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestHandler.class);
    public static final AttributeKey<Boolean> PROXYING = AttributeKey.valueOf((String)"PROXYING");
    public static final AttributeKey<Set<String>> LOCAL_HOST_HEADERS = AttributeKey.valueOf((String)"LOCAL_HOST_HEADERS");
    private final ServerConfiguration configuration;
    private final LifeCycle server;
    private final HttpState httpState;
    private final PortBindingSerializer portBindingSerializer;
    private final HttpActionHandler httpActionHandler;

    public HttpRequestHandler(ServerConfiguration configuration, LifeCycle server, HttpState httpState, HttpActionHandler httpActionHandler) {
        super(false);
        this.configuration = configuration;
        this.server = server;
        this.httpState = httpState;
        this.portBindingSerializer = new PortBindingSerializer();
        this.httpActionHandler = httpActionHandler;
    }

    private static boolean isProxyingRequest(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel() != null && ctx.channel().attr(PROXYING).get() != null) {
            return (Boolean)ctx.channel().attr(PROXYING).get();
        }
        return false;
    }

    public static void setProxyingRequest(ChannelHandlerContext ctx, Boolean value) {
        if (ctx != null && ctx.channel() != null) {
            ctx.channel().attr(PROXYING).set((Object)value);
        }
    }

    private static Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(LOCAL_HOST_HEADERS) != null && ctx.channel().attr(LOCAL_HOST_HEADERS).get() != null) {
            return (Set)ctx.channel().attr(LOCAL_HOST_HEADERS).get();
        }
        return new HashSet<String>();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block16: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(this.configuration, ctx, this.httpState.getScheduler());
            try {
                if (this.httpState.handle(request, responseWriter, false)) break block16;
                if (request.matches("PUT", new String[]{"/mockserver/status", "/status"}) || StringUtils.isNotBlank((String)this.configuration.livenessHttpGetPath()) && request.matches("GET", new String[]{this.configuration.livenessHttpGetPath()})) {
                    responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getLocalPorts())), "application/json");
                    break block16;
                }
                if (request.matches("PUT", new String[]{"/mockserver/bind", "/bind"})) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    if (requestedPortBindings == null) break block16;
                    try {
                        List<Integer> actualPortBindings = this.server.bindServerPorts(requestedPortBindings.getPorts());
                        responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block16;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block16;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", new String[]{"/mockserver/stop", "/stop"})) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new SchedulerThreadFactory("MockServer Stop").newThread(this.server::stop).start();
                } else if ("CONNECT".equals(request.getMethod().getValue())) {
                    String username = this.configuration.proxyAuthenticationUsername();
                    String password = this.configuration.proxyAuthenticationPassword();
                    if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password) && !request.containsHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString(), "Basic " + Base64Converter.bytesToBase64String((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8), (Charset)StandardCharsets.US_ASCII))) {
                        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code())).withHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), new String[]{"Basic realm=\"" + StringEscapeUtils.escapeJava((String)this.configuration.proxyAuthenticationRealm()) + "\", charset=\"UTF-8\""});
                        ctx.writeAndFlush((Object)response);
                        LOG.info("Proxy authentication failed so returning response: {} for forwarded request: {}", (Object)response, (Object)request);
                    } else {
                        HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
                        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
                        String[] hostParts = request.getPath().getValue().split(":");
                        int port = hostParts.length > 1 ? Integer.parseInt(hostParts[1]) : (PortUnificationHandler.isSslEnabledUpstream(ctx.channel()) ? 443 : 80);
                        ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(this.configuration, this.server, hostParts[0], port)});
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)request);
                    }
                } else {
                    try {
                        this.httpActionHandler.processAction(request, responseWriter, ctx, HttpRequestHandler.getLocalAddresses(ctx), HttpRequestHandler.isProxyingRequest(ctx), false);
                    }
                    catch (Exception ex) {
                        LOG.error("Exception processing request: {}", (Object)request, (Object)ex);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                LOG.error("Exception processing request: {}", (Object)request, (Object)iae);
                responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception ex) {
                LOG.error("Exception processing {}", (Object)request, (Object)ex);
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(ex.getMessage()), true);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            LOG.error("Exception caught by {} handler -> closing pipeline {}", this.server.getClass(), (Object)ctx.channel());
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

