/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.action.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.mock.action.ExpectationResponseCallback;
import software.xdev.mockserver.model.HttpClassCallback;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.HttpResponse;

public class HttpResponseClassCallbackActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseClassCallbackActionHandler.class);
    private static ClassLoader contextClassLoader = ClassLoader.getSystemClassLoader();

    public static void setContextClassLoader(ClassLoader contextClassLoader) {
        HttpResponseClassCallbackActionHandler.contextClassLoader = contextClassLoader;
    }

    public HttpResponse handle(HttpClassCallback httpClassCallback, HttpRequest request) {
        return this.invokeCallbackMethod(httpClassCallback, request);
    }

    private ExpectationResponseCallback instantiateCallback(HttpClassCallback httpClassCallback) {
        try {
            Class<?> expectationResponseCallbackClass = contextClassLoader.loadClass(httpClassCallback.getCallbackClass());
            if (ExpectationResponseCallback.class.isAssignableFrom(expectationResponseCallbackClass)) {
                Constructor<?> constructor = expectationResponseCallbackClass.getConstructor(new Class[0]);
                return (ExpectationResponseCallback)constructor.newInstance(new Object[0]);
            }
            LOG.error("{} does not implement {} required for responses using class callback", (Object)httpClassCallback.getCallbackClass(), (Object)ExpectationResponseCallback.class.getName());
        }
        catch (ClassNotFoundException e) {
            LOG.error("ClassNotFoundException - while trying to instantiate ExpectationResponseCallback class \"{}\"", (Object)httpClassCallback.getCallbackClass(), (Object)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("NoSuchMethodException - while trying to create default constructor on ExpectationResponseCallback class \"{}\"", (Object)httpClassCallback.getCallbackClass(), (Object)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("InvocationTargetException - while trying to execute default constructor on ExpectationResponseCallback class \"{}\"", (Object)httpClassCallback.getCallbackClass(), (Object)e);
        }
        return null;
    }

    private HttpResponse invokeCallbackMethod(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationResponseCallback expectationResponseCallback = this.instantiateCallback(httpClassCallback);
            if (expectationResponseCallback != null) {
                try {
                    return expectationResponseCallback.handle(httpRequest);
                }
                catch (Exception ex) {
                    LOG.error("{} throw exception while executing handle callback method", (Object)httpClassCallback.getCallbackClass(), (Object)ex);
                    return HttpResponse.notFoundResponse();
                }
            }
            return HttpResponse.notFoundResponse();
        }
        return HttpResponse.notFoundResponse();
    }
}

