/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.codec.ExpandedParameterDecoder;
import software.xdev.mockserver.codec.PathParametersDecoder;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.matchers.AbstractHttpRequestMatcher;
import software.xdev.mockserver.matchers.BinaryMatcher;
import software.xdev.mockserver.matchers.BodyMatcher;
import software.xdev.mockserver.matchers.BooleanMatcher;
import software.xdev.mockserver.matchers.ExactStringMatcher;
import software.xdev.mockserver.matchers.HashMapMatcher;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.MatchDifferenceCount;
import software.xdev.mockserver.matchers.Matcher;
import software.xdev.mockserver.matchers.MultiValueMapMatcher;
import software.xdev.mockserver.matchers.ParameterStringMatcher;
import software.xdev.mockserver.matchers.RegexStringMatcher;
import software.xdev.mockserver.matchers.SubStringMatcher;
import software.xdev.mockserver.model.BinaryBody;
import software.xdev.mockserver.model.Body;
import software.xdev.mockserver.model.Cookies;
import software.xdev.mockserver.model.Headers;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.KeyAndValue;
import software.xdev.mockserver.model.KeyToMultiValue;
import software.xdev.mockserver.model.KeysAndValues;
import software.xdev.mockserver.model.KeysToMultiValues;
import software.xdev.mockserver.model.NottableString;
import software.xdev.mockserver.model.Parameter;
import software.xdev.mockserver.model.ParameterBody;
import software.xdev.mockserver.model.Parameters;
import software.xdev.mockserver.model.Protocol;
import software.xdev.mockserver.model.RegexBody;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.model.StringBody;
import software.xdev.mockserver.serialization.ObjectMapperFactory;
import software.xdev.mockserver.serialization.deserializers.body.StrictBodyDTODeserializer;
import software.xdev.mockserver.serialization.model.BodyDTO;
import software.xdev.mockserver.util.StringUtils;

public class HttpRequestPropertiesMatcher
extends AbstractHttpRequestMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestPropertiesMatcher.class);
    private static final String COMMA = ",";
    private static final String REQUEST_NOT_OPERATOR_IS_ENABLED = ",\nrequest 'not' operator is enabled";
    private static final String EXPECTATION_REQUEST_NOT_OPERATOR_IS_ENABLED = ",\nexpectation's request 'not' operator is enabled";
    private static final String EXPECTATION_REQUEST_MATCHER_NOT_OPERATOR_IS_ENABLED = ",\nexpectation's request matcher 'not' operator is enabled";
    private static final PathParametersDecoder PATH_PARAMETERS_DECODER = new PathParametersDecoder();
    private static final ObjectWriter TO_STRING_OBJECT_WRITER = ObjectMapperFactory.createObjectMapper((boolean)true, (boolean)false, (JsonSerializer[])new JsonSerializer[0]);
    private final ExpandedParameterDecoder expandedParameterDecoder;
    private int hashCode;
    private HttpRequest httpRequest;
    private List<HttpRequest> httpRequests;
    private RegexStringMatcher methodMatcher;
    private RegexStringMatcher pathMatcher;
    private MultiValueMapMatcher pathParameterMatcher;
    private MultiValueMapMatcher queryStringParameterMatcher;
    private BodyMatcher bodyMatcher;
    private MultiValueMapMatcher headerMatcher;
    private HashMapMatcher cookieMatcher;
    private BooleanMatcher keepAliveMatcher;
    private ExactStringMatcher protocolMatcher;
    private ObjectMapper objectMapperWithStrictBodyDTODeserializer;

    public HttpRequestPropertiesMatcher(ServerConfiguration configuration) {
        super(configuration);
        this.expandedParameterDecoder = new ExpandedParameterDecoder(configuration);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public List<HttpRequest> getHttpRequests() {
        return this.httpRequests;
    }

    @Override
    public boolean apply(RequestDefinition requestDefinition) {
        HttpRequest r;
        HttpRequest httpRequest;
        HttpRequest httpRequest2 = httpRequest = requestDefinition instanceof HttpRequest ? (r = (HttpRequest)requestDefinition) : null;
        if (this.httpRequest == null || !this.httpRequest.equals((Object)httpRequest)) {
            this.hashCode = 0;
            this.httpRequest = httpRequest;
            this.httpRequests = Collections.singletonList(this.httpRequest);
            if (httpRequest != null) {
                this.withMethod(httpRequest.getMethod());
                this.withPath(httpRequest);
                this.withPathParameters(httpRequest.getPathParameters());
                this.withQueryStringParameters(httpRequest.getQueryStringParameters());
                this.withBody(httpRequest.getBody());
                this.withHeaders(httpRequest.getHeaders());
                this.withCookies(httpRequest.getCookies());
                this.withKeepAlive(httpRequest.isKeepAlive());
                this.withProtocol(httpRequest.getProtocol());
            }
            return true;
        }
        return false;
    }

    public HttpRequestPropertiesMatcher withControlPlaneMatcher(boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        return this;
    }

    private void withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(method, this.controlPlaneMatcher);
    }

    private void withPath(HttpRequest httpRequest) {
        this.pathMatcher = new RegexStringMatcher(PATH_PARAMETERS_DECODER.normalisePathWithParametersForMatching(httpRequest), this.controlPlaneMatcher);
    }

    private void withPathParameters(Parameters parameters) {
        this.pathParameterMatcher = new MultiValueMapMatcher((KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>)parameters, this.controlPlaneMatcher);
    }

    private void withQueryStringParameters(Parameters parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher((KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>)parameters, this.controlPlaneMatcher);
    }

    private void withBody(Body body) {
        this.bodyMatcher = this.buildBodyMatcher(body);
    }

    private BodyMatcher buildBodyMatcher(Body body) {
        if (body == null) {
            return null;
        }
        BodyMatcher matcher = this.determineBodyMatcherByType(body);
        return body.isNot() ? HttpRequestPropertiesMatcher.notMatcher(matcher) : matcher;
    }

    private BodyMatcher determineBodyMatcherByType(Body body) {
        return switch (body.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Body.Type.STRING -> {
                StringBody stringBody = (StringBody)body;
                NottableString string = NottableString.string((String)stringBody.getValue());
                if (stringBody.isSubString()) {
                    yield new SubStringMatcher(string);
                }
                yield new ExactStringMatcher(string);
            }
            case Body.Type.REGEX -> {
                RegexBody regexBody = (RegexBody)body;
                yield new RegexStringMatcher(NottableString.string((String)regexBody.getValue()), this.controlPlaneMatcher);
            }
            case Body.Type.PARAMETERS -> {
                ParameterBody parameterBody = (ParameterBody)body;
                yield new ParameterStringMatcher(this.configuration, parameterBody.getValue(), this.controlPlaneMatcher);
            }
            case Body.Type.BINARY -> {
                BinaryBody binaryBody = (BinaryBody)body;
                yield new BinaryMatcher(binaryBody.getValue());
            }
        };
    }

    private void withHeaders(Headers headers) {
        this.headerMatcher = new MultiValueMapMatcher((KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>)headers, this.controlPlaneMatcher);
    }

    private void withCookies(Cookies cookies) {
        this.cookieMatcher = new HashMapMatcher((KeysAndValues<? extends KeyAndValue, ? extends KeysAndValues>)cookies, this.controlPlaneMatcher);
    }

    private void withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(keepAlive);
    }

    private void withProtocol(Protocol protocol) {
        this.protocolMatcher = new ExactStringMatcher(protocol != null ? NottableString.string((String)protocol.name()) : null);
    }

    @Override
    public boolean matches(MatchDifference context, RequestDefinition requestDefinition) {
        if (requestDefinition instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)requestDefinition;
            StringBuilder becauseBuilder = new StringBuilder();
            boolean overallMatch = this.matches(context, request, becauseBuilder);
            if (!this.controlPlaneMatcher) {
                if (overallMatch) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(this.expectation == null ? "request: {} matched request: {}" : "request: {} matched expectation: {}", (Object)request, (Object)(this.expectation == null ? this : this.expectation.clone()));
                    }
                } else {
                    becauseBuilder.replace(0, 1, "");
                    String because = becauseBuilder.toString();
                    if (LOG.isInfoEnabled()) {
                        LOG.info(this.expectation == null ? this.didNotMatchRequestBecause : (!becauseBuilder.isEmpty() ? this.didNotMatchExpectationBecause : this.didNotMatchExpectationWithoutBecause), new Object[]{request, this.expectation == null ? this : this.expectation.clone(), because});
                    }
                }
            }
            return overallMatch;
        }
        return requestDefinition == null;
    }

    private boolean matches(MatchDifference context, HttpRequest request, StringBuilder becauseBuilder) {
        if (this.isActive()) {
            if (request == this.httpRequest) {
                return true;
            }
            if (this.httpRequest == null) {
                return true;
            }
            MatchDifferenceCount matchDifferenceCount = new MatchDifferenceCount(request);
            if (request != null) {
                boolean queryStringParametersMatches;
                Parameters pathParameters;
                boolean pathMatches;
                block23: {
                    boolean methodMatches;
                    boolean bl = methodMatches = StringUtils.isBlank((String)request.getMethod().getValue()) || this.matches(MatchDifference.Field.METHOD, context, this.methodMatcher, request.getMethod());
                    if (this.failFast(this.methodMatcher, context, matchDifferenceCount, becauseBuilder, methodMatches, MatchDifference.Field.METHOD)) {
                        return false;
                    }
                    pathMatches = StringUtils.isBlank((String)request.getPath().getValue()) || this.matches(MatchDifference.Field.PATH, context, this.pathMatcher, this.controlPlaneMatcher ? PATH_PARAMETERS_DECODER.normalisePathWithParametersForMatching(request) : request.getPath());
                    pathParameters = null;
                    try {
                        pathParameters = PATH_PARAMETERS_DECODER.extractPathParameters(this.httpRequest, request);
                    }
                    catch (IllegalArgumentException iae) {
                        if (this.httpRequest.getPath().isBlank()) break block23;
                        if (context != null) {
                            context.currentField(MatchDifference.Field.PATH);
                            context.addDifference(iae.getMessage(), new Object[0]);
                        }
                        pathMatches = false;
                    }
                }
                if (this.failFast(this.pathMatcher, context, matchDifferenceCount, becauseBuilder, pathMatches, MatchDifference.Field.PATH)) {
                    return false;
                }
                boolean bodyMatches = this.bodyMatches(context, request);
                if (this.failFast(this.bodyMatcher, context, matchDifferenceCount, becauseBuilder, bodyMatches, MatchDifference.Field.BODY)) {
                    return false;
                }
                boolean headersMatch = this.matches(MatchDifference.Field.HEADERS, context, this.headerMatcher, request.getHeaders());
                if (this.failFast(this.headerMatcher, context, matchDifferenceCount, becauseBuilder, headersMatch, MatchDifference.Field.HEADERS)) {
                    return false;
                }
                boolean cookiesMatch = this.matches(MatchDifference.Field.COOKIES, context, this.cookieMatcher, request.getCookies());
                if (this.failFast(this.cookieMatcher, context, matchDifferenceCount, becauseBuilder, cookiesMatch, MatchDifference.Field.COOKIES)) {
                    return false;
                }
                boolean pathParametersMatches = true;
                if (!this.httpRequest.getPath().isBlank()) {
                    if (!this.controlPlaneMatcher) {
                        this.expandedParameterDecoder.splitParameters(this.httpRequest.getPathParameters(), pathParameters);
                    }
                    MultiValueMapMatcher pathParameterMatcher = this.pathParameterMatcher;
                    if (this.controlPlaneMatcher) {
                        Parameters controlPlaneParameters;
                        try {
                            controlPlaneParameters = PATH_PARAMETERS_DECODER.extractPathParameters(request, this.httpRequest);
                        }
                        catch (IllegalArgumentException iae) {
                            controlPlaneParameters = new Parameters(new Parameter[0]);
                        }
                        pathParameterMatcher = new MultiValueMapMatcher((KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>)controlPlaneParameters, this.controlPlaneMatcher);
                    }
                    pathParametersMatches = this.matches(MatchDifference.Field.PATH_PARAMETERS, context, pathParameterMatcher, pathParameters);
                }
                if (this.failFast(this.pathParameterMatcher, context, matchDifferenceCount, becauseBuilder, pathParametersMatches, MatchDifference.Field.PATH_PARAMETERS)) {
                    return false;
                }
                if (!this.controlPlaneMatcher) {
                    this.expandedParameterDecoder.splitParameters(this.httpRequest.getQueryStringParameters(), request.getQueryStringParameters());
                }
                if (this.failFast(this.queryStringParameterMatcher, context, matchDifferenceCount, becauseBuilder, queryStringParametersMatches = this.matches(MatchDifference.Field.QUERY_PARAMETERS, context, this.queryStringParameterMatcher, request.getQueryStringParameters()), MatchDifference.Field.QUERY_PARAMETERS)) {
                    return false;
                }
                boolean keepAliveMatches = this.matches(MatchDifference.Field.KEEP_ALIVE, context, this.keepAliveMatcher, request.isKeepAlive());
                if (this.failFast(this.keepAliveMatcher, context, matchDifferenceCount, becauseBuilder, keepAliveMatches, MatchDifference.Field.KEEP_ALIVE)) {
                    return false;
                }
                boolean protocolMatches = this.matches(MatchDifference.Field.PROTOCOL, context, this.protocolMatcher, request.getProtocol() != null ? NottableString.string((String)request.getProtocol().name()) : null);
                if (this.failFast(this.protocolMatcher, context, matchDifferenceCount, becauseBuilder, protocolMatches, MatchDifference.Field.PROTOCOL)) {
                    return false;
                }
                boolean combinedResultAreTrue = HttpRequestPropertiesMatcher.combinedResultAreTrue(matchDifferenceCount.getFailures() == 0, request.isNot(), this.httpRequest.isNot(), this.not);
                if (!this.controlPlaneMatcher && combinedResultAreTrue) {
                    request.withPathParameters(pathParameters);
                }
                return combinedResultAreTrue;
            }
            return HttpRequestPropertiesMatcher.combinedResultAreTrue(true, this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private boolean failFast(Matcher<?> matcher, MatchDifference context, MatchDifferenceCount matchDifferenceCount, StringBuilder becauseBuilder, boolean fieldMatches, MatchDifference.Field fieldName) {
        if (!this.controlPlaneMatcher) {
            becauseBuilder.append("\n").append(fieldName.getName()).append(fieldMatches ? " matched" : " didn't match");
            if (context != null && context.getDifferences(fieldName) != null && !context.getDifferences(fieldName).isEmpty()) {
                becauseBuilder.append(": \n\n").append(String.join((CharSequence)"\n", context.getDifferences(fieldName)));
            }
        }
        if (!fieldMatches && !this.controlPlaneMatcher) {
            if (matchDifferenceCount.getHttpRequest().isNot()) {
                becauseBuilder.append(REQUEST_NOT_OPERATOR_IS_ENABLED);
            }
            if (this.httpRequest.isNot()) {
                becauseBuilder.append(EXPECTATION_REQUEST_NOT_OPERATOR_IS_ENABLED);
            }
            if (this.not) {
                becauseBuilder.append(EXPECTATION_REQUEST_MATCHER_NOT_OPERATOR_IS_ENABLED);
            }
        }
        if (!fieldMatches) {
            matchDifferenceCount.incrementFailures();
        }
        if (matcher != null && !matcher.isBlank() && this.configuration.matchersFailFast().booleanValue()) {
            return HttpRequestPropertiesMatcher.combinedResultAreTrue(matchDifferenceCount.getFailures() != 0, matchDifferenceCount.getHttpRequest().isNot(), this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private static boolean combinedResultAreTrue(boolean ... inputs) {
        int count = 0;
        for (boolean input : inputs) {
            count += input ? 1 : 0;
        }
        return count % 2 != 0;
    }

    private boolean bodyMatches(MatchDifference context, HttpRequest request) {
        boolean bodyMatches;
        block13: {
            if (this.bodyMatcher != null) {
                if (this.controlPlaneMatcher) {
                    if (this.httpRequest.getBody() != null && String.valueOf(this.httpRequest.getBody()).equalsIgnoreCase(String.valueOf(request.getBody()))) {
                        bodyMatches = true;
                    } else if (this.bodyMatches(this.bodyMatcher, context, request)) {
                        bodyMatches = true;
                    } else if (StringUtils.isNotBlank((String)request.getBodyAsJsonOrXmlString())) {
                        try {
                            BodyDTO bodyDTO = (BodyDTO)this.getObjectMapperWithStrictBodyDTODeserializer().readValue(request.getBodyAsJsonOrXmlString(), BodyDTO.class);
                            if (bodyDTO != null) {
                                bodyMatches = this.bodyMatches(this.buildBodyMatcher(bodyDTO.buildObject()), context, this.httpRequest);
                                break block13;
                            }
                            bodyMatches = false;
                        }
                        catch (Exception ignore) {
                            bodyMatches = false;
                        }
                    } else {
                        bodyMatches = false;
                    }
                } else {
                    bodyMatches = this.bodyMatches(this.bodyMatcher, context, request);
                }
            } else {
                bodyMatches = true;
            }
        }
        return bodyMatches;
    }

    private boolean bodyMatches(BodyMatcher bodyMatcher, MatchDifference context, HttpRequest request) {
        boolean bodyMatches = this.httpRequest.getBody().getOptional() != null && this.httpRequest.getBody().getOptional() != false && request.getBody() == null ? true : (bodyMatcher instanceof BinaryMatcher ? this.matches(MatchDifference.Field.BODY, context, bodyMatcher, request.getBodyAsRawBytes()) : (bodyMatcher instanceof ExactStringMatcher || bodyMatcher instanceof SubStringMatcher || bodyMatcher instanceof RegexStringMatcher ? this.matches(MatchDifference.Field.BODY, context, bodyMatcher, NottableString.string((String)request.getBodyAsString())) : this.matches(MatchDifference.Field.BODY, context, bodyMatcher, request.getBodyAsString())));
        return bodyMatches;
    }

    private <T> boolean matches(MatchDifference.Field field, MatchDifference context, Matcher<T> matcher, T t) {
        if (context != null) {
            context.currentField(field);
        }
        return matcher == null || matcher.matches(context, t);
    }

    public String toString() {
        try {
            return TO_STRING_OBJECT_WRITER.writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequestPropertiesMatcher that = (HttpRequestPropertiesMatcher)o;
        return Objects.equals(this.httpRequest, that.httpRequest);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.httpRequest);
        }
        return this.hashCode;
    }

    private ObjectMapper getObjectMapperWithStrictBodyDTODeserializer() {
        if (this.objectMapperWithStrictBodyDTODeserializer == null) {
            this.objectMapperWithStrictBodyDTODeserializer = ObjectMapperFactory.createObjectMapper((JsonDeserializer[])new JsonDeserializer[]{new StrictBodyDTODeserializer()});
        }
        return this.objectMapperWithStrictBodyDTODeserializer;
    }
}

