/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.Matcher;

public class BooleanMatcher
implements Matcher<Boolean> {
    private final Boolean matcher;

    BooleanMatcher(Boolean matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(MatchDifference context, Boolean matched) {
        boolean result = false;
        if (this.matcher == null) {
            result = true;
        } else if (matched != null) {
            result = Objects.equals(matched, this.matcher);
        }
        if (!result && context != null) {
            context.addDifference("boolean match failed expected:{}found:{}", this.matcher, matched);
        }
        return result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanMatcher)) {
            return false;
        }
        BooleanMatcher that = (BooleanMatcher)o;
        return Objects.equals(this.matcher, that.matcher);
    }

    public int hashCode() {
        return Objects.hashCode(this.matcher);
    }
}

