/*
 * Copyright © 2024 XDEV Software (https://xdev.software)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package software.xdev.mockserver.mock.action.http;

import java.net.InetSocketAddress;

import software.xdev.mockserver.httpclient.NettyHttpClient;
import software.xdev.mockserver.model.HttpForward;
import software.xdev.mockserver.model.HttpRequest;


public class HttpForwardActionHandler extends HttpForwardAction
{
	public HttpForwardActionHandler(final NettyHttpClient httpClient)
	{
		super(httpClient);
	}
	
	public HttpForwardActionResult handle(final HttpForward httpForward, final HttpRequest httpRequest)
	{
		return this.sendRequest(httpRequest, new InetSocketAddress(httpForward.getHost(), httpForward.getPort()),
			null);
	}
}
