/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.serialization.java;

import software.xdev.mockserver.model.HttpForward;
import software.xdev.mockserver.serialization.java.DelayToJavaSerializer;
import software.xdev.mockserver.serialization.java.ToJavaSerializer;

public class HttpForwardToJavaSerializer
implements ToJavaSerializer<HttpForward> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpForward httpForward) {
        StringBuilder output = new StringBuilder();
        if (httpForward != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("forward()");
            if (httpForward.getHost() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHost(\"").append(httpForward.getHost()).append("\")");
            }
            if (httpForward.getPort() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withPort(").append(httpForward.getPort()).append(')');
            }
            if (httpForward.getScheme() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withScheme(HttpForward.Scheme.").append(httpForward.getScheme()).append(')');
            }
            if (httpForward.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpForward.getDelay())).append(')');
            }
        }
        return output.toString();
    }

    private StringBuilder appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuilder output) {
        return output.append("\n").append(" ".repeat(numberOfSpacesToIndent));
    }
}

