/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.proxy.socks;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.exception.ExceptionHandling;
import software.xdev.mockserver.lifecycle.LifeCycle;
import software.xdev.mockserver.netty.HttpRequestHandler;

@ChannelHandler.Sharable
public abstract class SocksProxyHandler<T>
extends SimpleChannelInboundHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SocksProxyHandler.class);
    protected final ServerConfiguration configuration;
    protected final LifeCycle server;

    protected SocksProxyHandler(ServerConfiguration configuration, LifeCycle server) {
        super(false);
        this.configuration = configuration;
        this.server = server;
    }

    protected void forwardConnection(ChannelHandlerContext ctx, ChannelHandler forwarder) {
        HttpRequestHandler.setProxyingRequest(ctx, Boolean.TRUE);
        ctx.pipeline().replace((ChannelHandler)this, null, forwarder);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            LOG.error("Exception caught by SOCKS proxy handler -> closing pipeline {}", (Object)ctx.channel(), (Object)cause);
        }
        ctx.close();
    }
}

