/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.netty.proxy.socks;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5Message;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.lifecycle.LifeCycle;
import software.xdev.mockserver.netty.proxy.socks.Socks5ConnectHandler;
import software.xdev.mockserver.netty.proxy.socks.SocksProxyHandler;
import software.xdev.mockserver.netty.unification.PortUnificationHandler;
import software.xdev.mockserver.util.StringUtils;

@ChannelHandler.Sharable
public class Socks5ProxyHandler
extends SocksProxyHandler<Socks5Message> {
    private static final Logger LOG = LoggerFactory.getLogger(Socks5ProxyHandler.class);

    public Socks5ProxyHandler(ServerConfiguration configuration, LifeCycle server) {
        super(configuration, server);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Socks5Message socksRequest) {
        if (socksRequest instanceof Socks5InitialRequest) {
            this.handleInitialRequest(ctx, (Socks5InitialRequest)socksRequest);
        } else if (socksRequest instanceof Socks5PasswordAuthRequest) {
            this.handlePasswordAuthRequest(ctx, (Socks5PasswordAuthRequest)socksRequest);
        } else if (socksRequest instanceof Socks5CommandRequest) {
            this.handleCommandRequest(ctx, (Socks5CommandRequest)socksRequest);
        } else {
            ctx.close();
        }
    }

    private void handleInitialRequest(ChannelHandlerContext ctx, Socks5InitialRequest initialRequest) {
        Socks5CommandRequestDecoder nextRequestDecoder;
        Socks5AuthMethod requiredAuthMethod;
        String username = this.configuration.proxyAuthenticationUsername();
        String password = this.configuration.proxyAuthenticationPassword();
        if (initialRequest.authMethods().contains(Socks5AuthMethod.NO_AUTH)) {
            requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
            nextRequestDecoder = new Socks5CommandRequestDecoder();
        } else if (initialRequest.authMethods().contains(Socks5AuthMethod.PASSWORD)) {
            if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
                requiredAuthMethod = Socks5AuthMethod.PASSWORD;
                nextRequestDecoder = new Socks5PasswordAuthRequestDecoder();
            } else {
                requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
                nextRequestDecoder = new Socks5CommandRequestDecoder();
            }
        } else {
            requiredAuthMethod = Socks5AuthMethod.NO_AUTH;
            nextRequestDecoder = new Socks5CommandRequestDecoder();
        }
        this.answerInitialRequest(ctx, initialRequest, requiredAuthMethod, (ChannelHandler)nextRequestDecoder);
    }

    private void answerInitialRequest(ChannelHandlerContext ctx, Socks5InitialRequest initialRequest, Socks5AuthMethod requiredAuthMethod, ChannelHandler nextRequestDecoder) {
        ctx.writeAndFlush((Object)initialRequest.authMethods().stream().filter(authMethod -> authMethod.equals((Object)requiredAuthMethod)).findFirst().map(authMethod -> {
            if (PortUnificationHandler.isSslEnabledUpstream(ctx.channel())) {
                ctx.pipeline().addAfter("SslHandler#0", null, nextRequestDecoder);
            } else {
                ctx.pipeline().addFirst(new ChannelHandler[]{nextRequestDecoder});
            }
            return new DefaultSocks5InitialResponse(requiredAuthMethod);
        }).orElse(new DefaultSocks5InitialResponse(Socks5AuthMethod.UNACCEPTED)));
        ctx.pipeline().remove(Socks5InitialRequestDecoder.class);
    }

    private void handlePasswordAuthRequest(ChannelHandlerContext ctx, Socks5PasswordAuthRequest passwordAuthRequest) {
        String username = this.configuration.proxyAuthenticationUsername();
        String password = this.configuration.proxyAuthenticationPassword();
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password) && username.equals(passwordAuthRequest.username()) && password.equals(passwordAuthRequest.password())) {
            ctx.pipeline().replace(Socks5PasswordAuthRequestDecoder.class, null, (ChannelHandler)new Socks5CommandRequestDecoder());
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS)).awaitUninterruptibly();
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            LOG.info("Proxy authentication failed so returning SOCKS FAILURE response");
        }
    }

    private void handleCommandRequest(ChannelHandlerContext ctx, Socks5CommandRequest commandRequest) {
        if (commandRequest.type().equals((Object)Socks5CommandType.CONNECT)) {
            this.forwardConnection(ctx, (ChannelHandler)new Socks5ConnectHandler(this.configuration, this.server, commandRequest.dstAddr(), commandRequest.dstPort()));
            ctx.fireChannelRead((Object)commandRequest);
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.COMMAND_UNSUPPORTED, Socks5AddressType.DOMAIN, "", 0)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

