/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.mock.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.xdev.mockserver.mock.RequestMatchers;
import software.xdev.mockserver.mock.listeners.MockServerMatcherListener;
import software.xdev.mockserver.scheduler.Scheduler;

public class MockServerMatcherNotifier {
    private boolean listenerAdded;
    private final List<MockServerMatcherListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Scheduler scheduler;

    public MockServerMatcherNotifier(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void notifyListeners(RequestMatchers notifier, Cause cause) {
        if (this.listenerAdded && !this.listeners.isEmpty()) {
            for (MockServerMatcherListener listener : this.listeners.toArray(new MockServerMatcherListener[0])) {
                this.scheduler.submit(() -> listener.updated(notifier, cause));
            }
        }
    }

    public void registerListener(MockServerMatcherListener listener) {
        this.listeners.add(listener);
        this.listenerAdded = true;
    }

    public void unregisterListener(MockServerMatcherListener listener) {
        this.listeners.remove(listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockServerMatcherNotifier)) {
            return false;
        }
        MockServerMatcherNotifier that = (MockServerMatcherNotifier)o;
        return this.listenerAdded == that.listenerAdded && Objects.equals(this.listeners, that.listeners) && Objects.equals(this.scheduler, that.scheduler);
    }

    public int hashCode() {
        return Objects.hash(this.listenerAdded, this.listeners, this.scheduler);
    }

    public static class Cause {
        public static final Cause API = new Cause("", Type.API);
        private final String source;
        private final Type type;

        public Cause(String source, Type type) {
            this.source = source;
            this.type = type;
        }

        public String getSource() {
            return this.source;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cause cause = (Cause)o;
            return Objects.equals(this.source, cause.source) && this.type == cause.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.source, this.type});
        }

        public static enum Type {
            FILE_INITIALISER,
            CLASS_INITIALISER,
            API;

        }
    }
}

