/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.Objects;
import software.xdev.mockserver.collections.NottableStringMultiMap;
import software.xdev.mockserver.matchers.MatchDifference;
import software.xdev.mockserver.matchers.NotMatcher;
import software.xdev.mockserver.model.KeyMatchStyle;
import software.xdev.mockserver.model.KeyToMultiValue;
import software.xdev.mockserver.model.KeysToMultiValues;

public class MultiValueMapMatcher
extends NotMatcher<KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>> {
    private final NottableStringMultiMap matcher;
    private final KeysToMultiValues keysToMultiValues;
    private final boolean controlPlaneMatcher;
    private Boolean allKeysNotted;
    private Boolean allKeysOptional;

    MultiValueMapMatcher(KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues> keysToMultiValues, boolean controlPlaneMatcher) {
        this.keysToMultiValues = keysToMultiValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysToMultiValues != null ? new NottableStringMultiMap(this.controlPlaneMatcher, keysToMultiValues.getKeyMatchStyle(), keysToMultiValues.getEntries()) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues> matched) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (matched == null || matched.isEmpty()) {
            if (this.allKeysNotted == null) {
                this.allKeysNotted = this.matcher.allKeysNotted();
            }
            if (this.allKeysOptional == null) {
                this.allKeysOptional = this.matcher.allKeysOptional();
            }
            result = this.allKeysNotted != false || this.allKeysOptional != false;
        } else {
            result = new NottableStringMultiMap(this.controlPlaneMatcher, matched.getKeyMatchStyle(), matched.getEntries()).containsAll(context, this.matcher);
        }
        if (!result && context != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.keysToMultiValues;
            Object object = objectArray[1] = matched != null ? matched : "none";
            objectArray[2] = matched != null ? (this.matcher.getKeyMatchStyle() == KeyMatchStyle.SUB_SET ? "multimap is not a subset" : "multimap values don't match") : "none is not a subset";
            context.addDifference("multimap match failed expected:{}found:{}failed because:{}", objectArray);
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiValueMapMatcher)) {
            return false;
        }
        MultiValueMapMatcher that = (MultiValueMapMatcher)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.controlPlaneMatcher == that.controlPlaneMatcher && Objects.equals(this.matcher, that.matcher) && Objects.equals(this.keysToMultiValues, that.keysToMultiValues) && Objects.equals(this.allKeysNotted, that.allKeysNotted) && Objects.equals(this.allKeysOptional, that.allKeysOptional);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.matcher, this.keysToMultiValues, this.controlPlaneMatcher, this.allKeysNotted, this.allKeysOptional);
    }
}

