/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.matchers;

import java.util.concurrent.TimeUnit;
import software.xdev.mockserver.cache.LRUCache;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.matchers.HttpRequestMatcher;
import software.xdev.mockserver.matchers.HttpRequestPropertiesMatcher;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.model.RequestDefinition;

public class MatcherBuilder {
    private final ServerConfiguration configuration;
    private final LRUCache<RequestDefinition, HttpRequestMatcher> requestMatcherLRUCache;

    public MatcherBuilder(ServerConfiguration configuration) {
        this.configuration = configuration;
        this.requestMatcherLRUCache = new LRUCache(250, TimeUnit.MINUTES.toMillis(10L));
    }

    public HttpRequestMatcher transformsToMatcher(RequestDefinition requestDefinition) {
        HttpRequestMatcher httpRequestMatcher = this.requestMatcherLRUCache.get(requestDefinition);
        if (httpRequestMatcher == null) {
            httpRequestMatcher = new HttpRequestPropertiesMatcher(this.configuration);
            httpRequestMatcher.update(requestDefinition);
            this.requestMatcherLRUCache.put(requestDefinition, httpRequestMatcher);
        }
        return httpRequestMatcher;
    }

    public HttpRequestMatcher transformsToMatcher(Expectation expectation) {
        HttpRequestPropertiesMatcher httpRequestMatcher = new HttpRequestPropertiesMatcher(this.configuration);
        httpRequestMatcher.update(expectation);
        return httpRequestMatcher;
    }
}

