/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.event;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.xdev.mockserver.collections.CircularConcurrentLinkedDeque;
import software.xdev.mockserver.configuration.ServerConfiguration;
import software.xdev.mockserver.event.model.EventEntry;
import software.xdev.mockserver.event.model.RequestAndExpectationId;
import software.xdev.mockserver.matchers.HttpRequestMatcher;
import software.xdev.mockserver.matchers.MatcherBuilder;
import software.xdev.mockserver.mock.Expectation;
import software.xdev.mockserver.mock.listeners.MockServerEventLogNotifier;
import software.xdev.mockserver.model.ExpectationId;
import software.xdev.mockserver.model.HttpRequest;
import software.xdev.mockserver.model.LogEventRequestAndResponse;
import software.xdev.mockserver.model.RequestDefinition;
import software.xdev.mockserver.scheduler.Scheduler;
import software.xdev.mockserver.scheduler.SchedulerThreadFactory;
import software.xdev.mockserver.serialization.RequestDefinitionSerializer;
import software.xdev.mockserver.util.StringUtils;
import software.xdev.mockserver.uuid.UUIDService;
import software.xdev.mockserver.verify.Verification;
import software.xdev.mockserver.verify.VerificationSequence;

public class EventBus
extends MockServerEventLogNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(EventBus.class);
    private static final Predicate<EventEntry> REQUEST_LOG_PREDICATE = input -> !input.isDeleted() && input.getType() == EventEntry.EventType.RECEIVED_REQUEST;
    private static final Predicate<EventEntry> EXPECTATION_LOG_PREDICATE = input -> !input.isDeleted() && (input.getType() == EventEntry.EventType.EXPECTATION_RESPONSE || input.getType() == EventEntry.EventType.FORWARDED_REQUEST);
    private static final Predicate<EventEntry> REQUEST_RESPONSE_LOG_PREDICATE = input -> !input.isDeleted() && (input.getType() == EventEntry.EventType.EXPECTATION_RESPONSE || input.getType() == EventEntry.EventType.NO_MATCH_RESPONSE || input.getType() == EventEntry.EventType.FORWARDED_REQUEST);
    private static final Predicate<EventEntry> RECORDED_EXPECTATION_LOG_PREDICATE = input -> !input.isDeleted() && input.getType() == EventEntry.EventType.FORWARDED_REQUEST;
    private static final Function<EventEntry, RequestDefinition[]> LOG_ENTRY_TO_REQUEST = EventEntry::getHttpRequests;
    private static final Function<EventEntry, Expectation> LOG_ENTRY_TO_EXPECTATION = EventEntry::getExpectation;
    private static final Function<EventEntry, LogEventRequestAndResponse> LOG_ENTRY_TO_HTTP_REQUEST_AND_HTTP_RESPONSE = eventEntry -> new LogEventRequestAndResponse().withHttpRequest(eventEntry.getHttpRequest()).withHttpResponse(eventEntry.getHttpResponse()).withTimestamp(eventEntry.getTimestamp());
    private final ServerConfiguration configuration;
    private final CircularConcurrentLinkedDeque<EventEntry> eventLog;
    private final MatcherBuilder matcherBuilder;
    private final RequestDefinitionSerializer requestDefinitionSerializer;
    private final boolean asynchronousEventProcessing;
    private Disruptor<EventEntry> disruptor;

    public EventBus(ServerConfiguration configuration, Scheduler scheduler, boolean asynchronousEventProcessing) {
        super(scheduler);
        this.configuration = configuration;
        this.matcherBuilder = new MatcherBuilder(configuration);
        this.requestDefinitionSerializer = new RequestDefinitionSerializer();
        this.asynchronousEventProcessing = asynchronousEventProcessing;
        this.eventLog = new CircularConcurrentLinkedDeque<EventEntry>(configuration.maxLogEntries(), EventEntry::clear);
        this.startRingBuffer();
    }

    public void add(EventEntry eventEntry) {
        if (this.asynchronousEventProcessing) {
            if (!this.disruptor.getRingBuffer().tryPublishEvent((EventTranslator)eventEntry)) {
                LOG.warn("Too many log events failed to add log event to ring buffer: {}", (Object)eventEntry);
            }
        } else {
            this.processLogEntry(eventEntry);
        }
    }

    public int size() {
        return this.eventLog.size();
    }

    private void startRingBuffer() {
        this.disruptor = new Disruptor(EventEntry::new, this.configuration.ringBufferSize(), (ThreadFactory)new SchedulerThreadFactory("EventLog"));
        ExceptionHandler<EventEntry> errorHandler = new ExceptionHandler<EventEntry>(){

            public void handleEventException(Throwable ex, long sequence, EventEntry logEntry) {
                LOG.error("exception handling log entry in log ring buffer, for log entry: {}", (Object)logEntry, (Object)ex);
            }

            public void handleOnStartException(Throwable ex) {
                LOG.error("exception starting log ring buffer", ex);
            }

            public void handleOnShutdownException(Throwable ex) {
                LOG.error("exception during shutdown of log ring buffer", ex);
            }
        };
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)errorHandler);
        this.disruptor.handleEventsWith(new EventHandler[]{(eventEntry, sequence, endOfBatch) -> {
            if (eventEntry.getType() != EventEntry.EventType.RUNNABLE) {
                this.processLogEntry((EventEntry)eventEntry);
            } else {
                eventEntry.getConsumer().run();
                eventEntry.clear();
            }
        }});
        this.disruptor.start();
    }

    private void processLogEntry(EventEntry eventEntry) {
        this.eventLog.add(eventEntry.cloneAndClear());
        this.notifyListeners(this, false);
    }

    public void stop() {
        block2: {
            try {
                this.notifyListeners(this, true);
                this.eventLog.clear();
                this.disruptor.shutdown(2L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                if (ex instanceof TimeoutException || !LOG.isWarnEnabled()) break block2;
                LOG.warn("Exception while shutting down log ring buffer", (Throwable)ex);
            }
        }
    }

    public void reset() {
        CompletableFuture future = new CompletableFuture();
        this.disruptor.publishEvent((EventTranslator)new EventEntry().setType(EventEntry.EventType.RUNNABLE).setConsumer(() -> {
            this.eventLog.clear();
            future.complete("done");
            this.notifyListeners(this, false);
        }));
        try {
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException exception) {
            // empty catch block
        }
    }

    public void clear(RequestDefinition requestDefinition) {
        CompletableFuture future = new CompletableFuture();
        boolean markAsDeletedOnly = LOG.isInfoEnabled();
        this.disruptor.publishEvent((EventTranslator)new EventEntry().setType(EventEntry.EventType.RUNNABLE).setConsumer(() -> {
            String logCorrelationId = UUIDService.getUUID();
            RequestDefinition matcher = requestDefinition != null ? requestDefinition : HttpRequest.request().withLogCorrelationId(logCorrelationId);
            HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(matcher);
            for (EventEntry eventEntry : new LinkedList<EventEntry>(this.eventLog)) {
                RequestDefinition[] requests = eventEntry.getHttpRequests();
                boolean matches = false;
                if (requests != null) {
                    for (RequestDefinition request : requests) {
                        if (!requestMatcher.matches(request.cloneWithLogCorrelationId())) continue;
                        matches = true;
                    }
                } else {
                    matches = true;
                }
                if (!matches) continue;
                if (markAsDeletedOnly) {
                    eventEntry.setDeleted(true);
                    continue;
                }
                this.eventLog.removeItem(eventEntry);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Cleared logs that match: {}", (Object)requestDefinition);
            }
            future.complete("done");
            this.notifyListeners(this, false);
        }));
        try {
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException exception) {
            // empty catch block
        }
    }

    public void retrieveRequests(Verification verification, String logCorrelationId, Consumer<List<RequestDefinition>> listConsumer) {
        if (verification.getExpectationId() != null) {
            this.retrieveLogEntries(Collections.singletonList(verification.getExpectationId().getId()), EXPECTATION_LOG_PREDICATE, LOG_ENTRY_TO_REQUEST, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList())));
        } else {
            this.retrieveLogEntries(verification.getHttpRequest().withLogCorrelationId(logCorrelationId), REQUEST_LOG_PREDICATE, LOG_ENTRY_TO_REQUEST, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList())));
        }
    }

    public void retrieveAllRequests(boolean matchingExpectationsOnly, Consumer<List<RequestDefinition>> listConsumer) {
        if (matchingExpectationsOnly) {
            this.retrieveLogEntries((List<String>)null, EXPECTATION_LOG_PREDICATE, LOG_ENTRY_TO_REQUEST, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList())));
        } else {
            this.retrieveLogEntries((RequestDefinition)null, REQUEST_LOG_PREDICATE, LOG_ENTRY_TO_REQUEST, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList())));
        }
    }

    public void retrieveAllRequests(List<String> expectationIds, Consumer<List<RequestAndExpectationId>> listConsumer) {
        this.retrieveLogEntries(expectationIds, EXPECTATION_LOG_PREDICATE, (EventEntry eventEntry) -> new RequestAndExpectationId(eventEntry.getHttpRequest(), eventEntry.getExpectationId()), (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRequests(RequestDefinition requestDefinition, Consumer<List<RequestDefinition>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, REQUEST_LOG_PREDICATE, LOG_ENTRY_TO_REQUEST, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).flatMap(Arrays::stream).collect(Collectors.toList())));
    }

    public void retrieveRequestResponses(RequestDefinition requestDefinition, Consumer<List<LogEventRequestAndResponse>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, REQUEST_RESPONSE_LOG_PREDICATE, LOG_ENTRY_TO_HTTP_REQUEST_AND_HTTP_RESPONSE, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public void retrieveRecordedExpectations(RequestDefinition requestDefinition, Consumer<List<Expectation>> listConsumer) {
        this.retrieveLogEntries(requestDefinition, RECORDED_EXPECTATION_LOG_PREDICATE, LOG_ENTRY_TO_EXPECTATION, (Stream<T> logEventStream) -> listConsumer.accept(logEventStream.filter(Objects::nonNull).collect(Collectors.toList())));
    }

    private <T> void retrieveLogEntries(RequestDefinition requestDefinition, Predicate<EventEntry> logEntryPredicate, Function<EventEntry, T> logEntryMapper, Consumer<Stream<T>> consumer) {
        this.disruptor.publishEvent((EventTranslator)new EventEntry().setType(EventEntry.EventType.RUNNABLE).setConsumer(() -> {
            RequestDefinition requestDefinitionMatcher = requestDefinition != null ? requestDefinition : HttpRequest.request().withLogCorrelationId(UUIDService.getUUID());
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinitionMatcher);
            consumer.accept(this.eventLog.stream().filter(logItem -> logItem.matches(httpRequestMatcher)).filter(logEntryPredicate).map(logEntryMapper));
        }));
    }

    private <T> void retrieveLogEntries(List<String> expectationIds, Predicate<EventEntry> logEntryPredicate, Function<EventEntry, T> logEntryMapper, Consumer<Stream<T>> consumer) {
        this.disruptor.publishEvent((EventTranslator)new EventEntry().setType(EventEntry.EventType.RUNNABLE).setConsumer(() -> consumer.accept(this.eventLog.stream().filter(logEntryPredicate).filter(logItem -> expectationIds == null || logItem.matchesAnyExpectationId(expectationIds)).map(logEntryMapper))));
    }

    public Future<String> verify(Verification verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(Verification verification, Consumer<String> resultConsumer) {
        String logCorrelationId = UUIDService.getUUID();
        if (verification != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("verifying requests that match: {}", (Object)verification);
            }
            this.retrieveRequests(verification, logCorrelationId, httpRequests -> {
                try {
                    if (!verification.getTimes().matches(httpRequests.size())) {
                        boolean matchByExpectationId = verification.getExpectationId() != null;
                        this.retrieveAllRequests(matchByExpectationId, (List<RequestDefinition> allRequests) -> {
                            String failureMessage;
                            Integer maximumNumberOfRequestToReturnInVerificationFailure;
                            String serializedRequestToBeVerified = this.requestDefinitionSerializer.serialize(true, verification.getHttpRequest());
                            Integer n = maximumNumberOfRequestToReturnInVerificationFailure = verification.getMaximumNumberOfRequestToReturnInVerificationFailure() != null ? verification.getMaximumNumberOfRequestToReturnInVerificationFailure() : this.configuration.maximumNumberOfRequestToReturnInVerificationFailure();
                            if (allRequests.size() < maximumNumberOfRequestToReturnInVerificationFailure) {
                                String serializedAllRequestInLog = allRequests.size() == 1 ? this.requestDefinitionSerializer.serialize(true, (RequestDefinition)allRequests.get(0)) : this.requestDefinitionSerializer.serialize(true, allRequests);
                                failureMessage = "Request not found " + String.valueOf(verification.getTimes()) + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                            } else {
                                failureMessage = "Request not found " + String.valueOf(verification.getTimes()) + ", expected:<" + serializedRequestToBeVerified + "> but was not found, found " + allRequests.size() + " other requests";
                            }
                            if (LOG.isInfoEnabled()) {
                                LOG.info("Request not found {}, expected: {} but was: {}", new Object[]{verification.getTimes(), verification.getHttpRequest(), allRequests.size() == 1 ? allRequests.get(0) : allRequests});
                            }
                            resultConsumer.accept(failureMessage);
                        });
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("request:{} found {}", (Object)verification.getHttpRequest(), (Object)verification.getTimes());
                        }
                        resultConsumer.accept("");
                    }
                }
                catch (Exception ex) {
                    LOG.error("exception while processing verification: {}", (Object)verification, (Object)ex);
                    resultConsumer.accept("exception while processing verification" + (String)(StringUtils.isNotBlank((String)ex.getMessage()) ? " " + ex.getMessage() : ""));
                }
            });
        } else {
            resultConsumer.accept("");
        }
    }

    public Future<String> verify(VerificationSequence verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(VerificationSequence verificationSequence, Consumer<String> resultConsumer) {
        if (verificationSequence != null) {
            String logCorrelationId = UUIDService.getUUID();
            if (LOG.isInfoEnabled()) {
                LOG.info("verifying sequence that match: {}", (Object)verificationSequence);
            }
            if (verificationSequence.getExpectationIds() != null && !verificationSequence.getExpectationIds().isEmpty()) {
                this.retrieveAllRequests(verificationSequence.getExpectationIds().stream().map(ExpectationId::getId).collect(Collectors.toList()), (List<RequestAndExpectationId> allRequests) -> {
                    List<RequestDefinition> requestDefinitions = allRequests.stream().map(RequestAndExpectationId::getRequestDefinition).collect(Collectors.toList());
                    try {
                        String failureMessage = "";
                        int requestLogCounter = 0;
                        for (ExpectationId expectationId : verificationSequence.getExpectationIds()) {
                            if (expectationId == null) continue;
                            boolean foundRequest = false;
                            while (!foundRequest && requestLogCounter < allRequests.size()) {
                                if (((RequestAndExpectationId)allRequests.get(requestLogCounter)).matches(expectationId)) {
                                    foundRequest = true;
                                }
                                ++requestLogCounter;
                            }
                            if (foundRequest) continue;
                            failureMessage = this.verificationSequenceFailureMessage(verificationSequence, logCorrelationId, requestDefinitions);
                            break;
                        }
                        this.verificationSequenceSuccessMessage(verificationSequence, resultConsumer, logCorrelationId, failureMessage);
                    }
                    catch (Exception ex) {
                        this.verificationSequenceExceptionHandler(verificationSequence, resultConsumer, logCorrelationId, ex, "exception while processing verification sequence:{}", "exception while processing verification sequence");
                    }
                });
            } else {
                this.retrieveAllRequests(false, (List<RequestDefinition> allRequests) -> {
                    try {
                        String failureMessage = "";
                        int requestLogCounter = 0;
                        for (RequestDefinition verificationHttpRequest : verificationSequence.getHttpRequests()) {
                            if (verificationHttpRequest == null) continue;
                            verificationHttpRequest.withLogCorrelationId(logCorrelationId);
                            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                            boolean foundRequest = false;
                            while (!foundRequest && requestLogCounter < allRequests.size()) {
                                if (httpRequestMatcher.matches(((RequestDefinition)allRequests.get(requestLogCounter)).cloneWithLogCorrelationId())) {
                                    foundRequest = true;
                                }
                                ++requestLogCounter;
                            }
                            if (foundRequest) continue;
                            failureMessage = this.verificationSequenceFailureMessage(verificationSequence, logCorrelationId, (List<RequestDefinition>)allRequests);
                            break;
                        }
                        this.verificationSequenceSuccessMessage(verificationSequence, resultConsumer, logCorrelationId, failureMessage);
                    }
                    catch (Exception ex) {
                        this.verificationSequenceExceptionHandler(verificationSequence, resultConsumer, logCorrelationId, ex, "exception:{} while processing verification sequence:{}", "exception while processing verification sequence");
                    }
                });
            }
        } else {
            resultConsumer.accept("");
        }
    }

    private void verificationSequenceSuccessMessage(VerificationSequence verificationSequence, Consumer<String> resultConsumer, String logCorrelationId, String failureMessage) {
        if (StringUtils.isBlank((String)failureMessage) && LOG.isInfoEnabled()) {
            LOG.info("request sequence found: {}", (Object)verificationSequence.getHttpRequests());
        }
        resultConsumer.accept(failureMessage);
    }

    private String verificationSequenceFailureMessage(VerificationSequence verificationSequence, String logCorrelationId, List<RequestDefinition> allRequests) {
        String failureMessage;
        Integer maximumNumberOfRequestToReturnInVerificationFailure;
        String serializedRequestToBeVerified = this.requestDefinitionSerializer.serialize(true, verificationSequence.getHttpRequests());
        Integer n = maximumNumberOfRequestToReturnInVerificationFailure = verificationSequence.getMaximumNumberOfRequestToReturnInVerificationFailure() != null ? verificationSequence.getMaximumNumberOfRequestToReturnInVerificationFailure() : this.configuration.maximumNumberOfRequestToReturnInVerificationFailure();
        if (allRequests.size() < maximumNumberOfRequestToReturnInVerificationFailure) {
            String serializedAllRequestInLog = allRequests.size() == 1 ? this.requestDefinitionSerializer.serialize(true, allRequests.get(0)) : this.requestDefinitionSerializer.serialize(true, allRequests);
            failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
        } else {
            failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was not found, found " + allRequests.size() + " other requests";
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Request sequence not found, expected: {} but was: {}", (Object)verificationSequence.getHttpRequests(), allRequests.size() == 1 ? allRequests.get(0) : allRequests);
        }
        return failureMessage;
    }

    private void verificationSequenceExceptionHandler(VerificationSequence verificationSequence, Consumer<String> resultConsumer, String logCorrelationId, Exception ex, String s, String s2) {
        LOG.error(s, (Object)verificationSequence, (Object)ex);
        resultConsumer.accept(s2 + (String)(StringUtils.isNotBlank((String)ex.getMessage()) ? " " + ex.getMessage() : ""));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventBus)) {
            return false;
        }
        EventBus that = (EventBus)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.asynchronousEventProcessing == that.asynchronousEventProcessing && Objects.equals((Object)this.configuration, (Object)that.configuration) && Objects.equals(this.eventLog, that.eventLog) && Objects.equals(this.matcherBuilder, that.matcherBuilder) && Objects.equals(this.requestDefinitionSerializer, that.requestDefinitionSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.configuration, this.eventLog, this.matcherBuilder, this.requestDefinitionSerializer, this.asynchronousEventProcessing});
    }
}

