/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerStringListParser {
    private static final Logger LOG = LoggerFactory.getLogger(IntegerStringListParser.class);

    public Integer[] toArray(String integers) {
        return this.toList(integers).toArray(new Integer[0]);
    }

    List<Integer> toList(String integers) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String integer : integers.split(",")) {
            try {
                integerList.add(Integer.parseInt(integer.trim()));
            }
            catch (NumberFormatException nfe) {
                LOG.error("NumberFormatException converting {} to integer", (Object)integer, (Object)nfe);
            }
        }
        return integerList;
    }

    public String toString(Integer[] integers) {
        return this.toString(Arrays.asList(integers));
    }

    public String toString(List<Integer> integers) {
        return integers.stream().map(String::valueOf).collect(Collectors.joining(","));
    }
}

