/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.collections;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;

public class CircularConcurrentLinkedDeque<E>
extends ConcurrentLinkedDeque<E> {
    private int maxSize;
    private final Consumer<E> onEvictCallback;

    public CircularConcurrentLinkedDeque(int maxSize, Consumer<E> onEvictCallback) {
        this.maxSize = maxSize;
        this.onEvictCallback = onEvictCallback;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E element) {
        if (this.maxSize > 0) {
            this.evictExcessElements();
            return super.add(element);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.maxSize > 0) {
            boolean result = false;
            for (E element : collection) {
                if (!this.add(element)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean offer(E element) {
        if (this.maxSize > 0) {
            this.evictExcessElements();
            return super.offer(element);
        }
        return false;
    }

    private void evictExcessElements() {
        if (this.onEvictCallback == null) {
            while (this.size() >= this.maxSize) {
                super.poll();
            }
        } else {
            while (this.size() >= this.maxSize) {
                this.onEvictCallback.accept(super.poll());
            }
        }
    }

    @Override
    public void clear() {
        if (this.onEvictCallback == null) {
            super.clear();
        } else {
            while (!this.isEmpty()) {
                this.onEvictCallback.accept(super.poll());
            }
        }
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        return super.remove(o);
    }

    public boolean removeItem(E e) {
        if (this.onEvictCallback != null) {
            this.onEvictCallback.accept(e);
        }
        return super.remove(e);
    }
}

