/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.chartjs.model.color;

import com.fasterxml.jackson.annotation.JsonValue;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;

public class HSLAColor {
    protected static final Random RANDOMIZER = new SecureRandom();
    protected final double hue;
    protected final double saturationPercent;
    protected final double lightnessPercent;
    protected final double alpha;

    public HSLAColor(double hue, double saturationPercent, double lightnessPercent, double alpha) {
        if (!(HSLAColor.isPercentWithinBounds(saturationPercent) && HSLAColor.isPercentWithinBounds(lightnessPercent) && HSLAColor.isAlphaWithinBounds(alpha))) {
            throw new IllegalArgumentException("at least one argument is not within bounds");
        }
        this.hue = hue;
        this.saturationPercent = saturationPercent;
        this.lightnessPercent = lightnessPercent;
        this.alpha = alpha;
    }

    public HSLAColor(double hue, double saturationPercent, double lightnessPercent) {
        this(hue, saturationPercent, lightnessPercent, 1.0);
    }

    public HSLAColor(HSLAColor color, double alpha) {
        if (color == null) {
            throw new IllegalArgumentException("Color argument may not be null");
        }
        if (!HSLAColor.isAlphaWithinBounds(alpha)) {
            throw new IllegalArgumentException("alpha double argument is not within allowed bounds: allowed values are between 0 and 1 (inclusive), but value passed is " + alpha);
        }
        this.hue = color.getHue();
        this.saturationPercent = color.getSaturationPercent();
        this.lightnessPercent = color.getLightnessPercent();
        this.alpha = alpha;
    }

    public static HSLAColor random() {
        double hue = RANDOMIZER.nextDouble() * 360.0;
        double saturationPercent = RANDOMIZER.nextDouble() * 100.0;
        double lightnessPercent = RANDOMIZER.nextDouble() * 100.0;
        double alpha = RANDOMIZER.nextDouble();
        return new HSLAColor(hue, saturationPercent, lightnessPercent, alpha);
    }

    public static boolean isPercentWithinBounds(double percent) {
        return Double.compare(0.0, percent) <= 0 && Double.compare(100.0, percent) >= 0;
    }

    public static boolean isAlphaWithinBounds(double alpha) {
        return Double.compare(0.0, alpha) <= 0 && Double.compare(1.0, alpha) >= 0;
    }

    public double getHue() {
        return this.hue;
    }

    public double getSaturationPercent() {
        return this.saturationPercent;
    }

    public double getLightnessPercent() {
        return this.lightnessPercent;
    }

    public double getAlpha() {
        return this.alpha;
    }

    @JsonValue
    public String hsla() {
        return "hsla(" + String.format(Locale.US, "%.3f", this.getHue()) + "," + String.format(Locale.US, "%.3f", this.getSaturationPercent()) + "%," + String.format(Locale.US, "%.3f", this.getLightnessPercent()) + "%," + String.format(Locale.US, "%.3f", this.getAlpha()) + ")";
    }

    public String toString() {
        return this.hsla();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HSLAColor)) {
            return false;
        }
        HSLAColor color = (HSLAColor)o;
        return Double.compare(this.getHue(), color.getHue()) == 0 && Double.compare(this.getSaturationPercent(), color.getSaturationPercent()) == 0 && Double.compare(this.getLightnessPercent(), color.getLightnessPercent()) == 0 && Double.compare(this.getAlpha(), color.getAlpha()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getHue(), this.getSaturationPercent(), this.getLightnessPercent(), this.getAlpha());
    }
}

