/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.MysqlxSession;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.CJCommunicationsException;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ColumnDefinition;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ProtocolEntity;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.ResultBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.Notice;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.StatementExecuteOk;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.XProtocol;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.x.XProtocolRowInputStream;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.result.Field;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.SqlMultiResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.SqlResult;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.SqlResultBuilder;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.xdevapi.SqlSingleResult;

public class StreamingSqlResultBuilder
implements ResultBuilder<SqlResult> {
    TimeZone defaultTimeZone;
    PropertySet pset;
    XProtocol protocol;
    StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();
    boolean isRowResult = false;
    ProtocolEntity lastEntity = null;
    List<SqlSingleResult> resultSets = new ArrayList<SqlSingleResult>();
    private SqlResult result;

    public StreamingSqlResultBuilder(MysqlxSession sess) {
        this.defaultTimeZone = sess.getServerSession().getDefaultTimeZone();
        this.pset = sess.getPropertySet();
        this.protocol = sess.getProtocol();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
        } else {
            this.lastEntity = entity;
        }
        AtomicBoolean readLastResult = new AtomicBoolean(false);
        Supplier<ProtocolEntity> okReader = () -> {
            if (readLastResult.get()) {
                throw new CJCommunicationsException("Invalid state attempting to read ok packet");
            }
            if (this.protocol.hasMoreResults()) {
                StatementExecuteOk res = this.statementExecuteOkBuilder.build();
                this.statementExecuteOkBuilder = new StatementExecuteOkBuilder();
                return res;
            }
            readLastResult.set(true);
            return this.protocol.readQueryResult(this.statementExecuteOkBuilder);
        };
        Supplier<SqlResult> resultStream = () -> {
            if (readLastResult.get()) {
                return null;
            }
            if (this.lastEntity != null && this.lastEntity instanceof Field || this.protocol.isSqlResultPending()) {
                ColumnDefinition cd;
                if (this.lastEntity != null && this.lastEntity instanceof Field) {
                    cd = this.protocol.readMetadata((Field)this.lastEntity, n -> this.statementExecuteOkBuilder.addProtocolEntity((ProtocolEntity)n));
                    this.lastEntity = null;
                } else {
                    cd = this.protocol.readMetadata();
                }
                return new SqlSingleResult(cd, this.protocol.getServerSession().getDefaultTimeZone(), new XProtocolRowInputStream(cd, this.protocol, n -> this.statementExecuteOkBuilder.addProtocolEntity((ProtocolEntity)n)), okReader, this.pset);
            }
            readLastResult.set(true);
            SqlResultBuilder rb = new SqlResultBuilder(this.defaultTimeZone, this.pset);
            rb.addProtocolEntity(entity);
            return this.protocol.readQueryResult(rb);
        };
        this.result = new SqlMultiResult(resultStream);
        return true;
    }

    @Override
    public SqlResult build() {
        return this.result;
    }
}

