/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.realtime.datamessage;

import com.google.gson.Gson;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JE\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001f\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#\u00a2\u0006\u0002\u0010$J\t\u0010%\u001a\u00020&H\u00d6\u0001J\u0006\u0010'\u001a\u00020\u0005J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/realtime/datamessage/DataMessage;", "", "timestampMs", "", "topic", "", "data", "", "senderAttendeeId", "senderExternalUserId", "throttled", "", "(JLjava/lang/String;[BLjava/lang/String;Ljava/lang/String;Z)V", "getData", "()[B", "getSenderAttendeeId", "()Ljava/lang/String;", "getSenderExternalUserId", "getThrottled", "()Z", "getTimestampMs", "()J", "getTopic", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "fromJson", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "hashCode", "", "text", "toString", "amazon-chime-sdk_release"})
public final class DataMessage {
    private final long timestampMs;
    @NotNull
    private final String topic;
    @NotNull
    private final byte[] data;
    @NotNull
    private final String senderAttendeeId;
    @NotNull
    private final String senderExternalUserId;
    private final boolean throttled;

    public DataMessage(long timestampMs, @NotNull String topic, @NotNull byte[] data, @NotNull String senderAttendeeId, @NotNull String senderExternalUserId, boolean throttled) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)senderAttendeeId, (String)"senderAttendeeId");
        Intrinsics.checkNotNullParameter((Object)senderExternalUserId, (String)"senderExternalUserId");
        this.timestampMs = timestampMs;
        this.topic = topic;
        this.data = data;
        this.senderAttendeeId = senderAttendeeId;
        this.senderExternalUserId = senderExternalUserId;
        this.throttled = throttled;
    }

    public final long getTimestampMs() {
        return this.timestampMs;
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final String getSenderAttendeeId() {
        return this.senderAttendeeId;
    }

    @NotNull
    public final String getSenderExternalUserId() {
        return this.senderExternalUserId;
    }

    public final boolean getThrottled() {
        return this.throttled;
    }

    @NotNull
    public final String text() {
        return new String(this.data, Charsets.UTF_8);
    }

    public final <T> T fromJson(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)new Gson().fromJson(this.text(), clazz);
    }

    public final long component1() {
        return this.timestampMs;
    }

    @NotNull
    public final String component2() {
        return this.topic;
    }

    @NotNull
    public final byte[] component3() {
        return this.data;
    }

    @NotNull
    public final String component4() {
        return this.senderAttendeeId;
    }

    @NotNull
    public final String component5() {
        return this.senderExternalUserId;
    }

    public final boolean component6() {
        return this.throttled;
    }

    @NotNull
    public final DataMessage copy(long timestampMs, @NotNull String topic, @NotNull byte[] data, @NotNull String senderAttendeeId, @NotNull String senderExternalUserId, boolean throttled) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)senderAttendeeId, (String)"senderAttendeeId");
        Intrinsics.checkNotNullParameter((Object)senderExternalUserId, (String)"senderExternalUserId");
        return new DataMessage(timestampMs, topic, data, senderAttendeeId, senderExternalUserId, throttled);
    }

    public static /* synthetic */ DataMessage copy$default(DataMessage dataMessage, long l, String string, byte[] byArray, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            l = dataMessage.timestampMs;
        }
        if ((n & 2) != 0) {
            string = dataMessage.topic;
        }
        if ((n & 4) != 0) {
            byArray = dataMessage.data;
        }
        if ((n & 8) != 0) {
            string2 = dataMessage.senderAttendeeId;
        }
        if ((n & 0x10) != 0) {
            string3 = dataMessage.senderExternalUserId;
        }
        if ((n & 0x20) != 0) {
            bl = dataMessage.throttled;
        }
        return dataMessage.copy(l, string, byArray, string2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "DataMessage(timestampMs=" + this.timestampMs + ", topic=" + this.topic + ", data=" + Arrays.toString(this.data) + ", senderAttendeeId=" + this.senderAttendeeId + ", senderExternalUserId=" + this.senderExternalUserId + ", throttled=" + this.throttled + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.timestampMs);
        result = result * 31 + this.topic.hashCode();
        result = result * 31 + Arrays.hashCode(this.data);
        result = result * 31 + this.senderAttendeeId.hashCode();
        result = result * 31 + this.senderExternalUserId.hashCode();
        int n = this.throttled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataMessage)) {
            return false;
        }
        DataMessage dataMessage = (DataMessage)other;
        if (this.timestampMs != dataMessage.timestampMs) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.topic, (Object)dataMessage.topic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)dataMessage.data)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.senderAttendeeId, (Object)dataMessage.senderAttendeeId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.senderExternalUserId, (Object)dataMessage.senderExternalUserId)) {
            return false;
        }
        return this.throttled == dataMessage.throttled;
    }
}

