/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRotation;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoScalingType;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglVideoRenderView;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.VideoLayoutMeasure;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultEglRenderer;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.ConsoleLogger;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J0\u00105\u001a\u0002022\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\tH\u0014J\u0018\u0010;\u001a\u0002022\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0014J\u0010\u0010>\u001a\u0002022\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u000202H\u0016J(\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\tH\u0016J\u0010\u0010H\u001a\u0002022\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010I\u001a\u0002022\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010J\u001a\u000202H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u000e\u0010%\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020'@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/SurfaceRenderView;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglVideoRenderView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "frameRotation", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRotation;", "value", "", "hardwareScaling", "getHardwareScaling", "()Z", "setHardwareScaling", "(Z)V", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "getLogger", "()Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "setLogger", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "mirror", "getMirror", "setMirror", "renderer", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultEglRenderer;", "getRenderer", "()Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultEglRenderer;", "renderer$delegate", "Lkotlin/Lazy;", "rotatedFrameHeight", "rotatedFrameWidth", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;", "scalingType", "getScalingType", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;", "setScalingType", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;)V", "surfaceHeight", "surfaceWidth", "videoLayoutMeasure", "Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/VideoLayoutMeasure;", "init", "", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthSpec", "heightSpec", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "release", "surfaceChanged", "holder", "Landroid/view/SurfaceHolder;", "format", "width", "height", "surfaceCreated", "surfaceDestroyed", "updateSurfaceSize", "amazon-chime-sdk_release"})
public class SurfaceRenderView
extends SurfaceView
implements SurfaceHolder.Callback,
EglVideoRenderView {
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    @NotNull
    private VideoRotation frameRotation;
    private int surfaceWidth;
    private int surfaceHeight;
    @NotNull
    private final VideoLayoutMeasure videoLayoutMeasure;
    @NotNull
    private final Lazy renderer$delegate;
    private boolean mirror;
    @NotNull
    private VideoScalingType scalingType;
    private boolean hardwareScaling;
    @NotNull
    private Logger logger;
    @NotNull
    private final String TAG;

    @JvmOverloads
    public SurfaceRenderView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, attrs, defStyle);
            this.frameRotation = VideoRotation.Rotation0;
            this.videoLayoutMeasure = new VideoLayoutMeasure();
            this.renderer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultEglRenderer>(this){
                final /* synthetic */ SurfaceRenderView this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final DefaultEglRenderer invoke() {
                    return new DefaultEglRenderer(this.this$0.getLogger());
                }
            }));
            this.scalingType = VideoScalingType.AspectFill;
            this.logger = new ConsoleLogger(null, 1, null);
            this.TAG = "SurfaceRenderView";
            SurfaceHolder surfaceHolder = this.getHolder();
            if (surfaceHolder == null) break block0;
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    public /* synthetic */ SurfaceRenderView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final DefaultEglRenderer getRenderer() {
        Lazy lazy = this.renderer$delegate;
        return (DefaultEglRenderer)lazy.getValue();
    }

    public final boolean getMirror() {
        return this.mirror;
    }

    public final void setMirror(boolean value) {
        this.logger.debug(this.TAG, "Setting mirror from " + this.mirror + " to " + value);
        this.getRenderer().setMirror(value);
        this.mirror = value;
    }

    @NotNull
    public final VideoScalingType getScalingType() {
        return this.scalingType;
    }

    public final void setScalingType(@NotNull VideoScalingType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.logger.debug(this.TAG, "Setting scaling type from " + this.scalingType + " to " + value);
        this.videoLayoutMeasure.setScalingType(value);
        this.scalingType = value;
    }

    public final boolean getHardwareScaling() {
        return this.hardwareScaling;
    }

    public final void setHardwareScaling(boolean value) {
        this.logger.debug(this.TAG, "Setting hardware scaling from " + this.hardwareScaling + " to " + value);
        this.hardwareScaling = value;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        this.logger = logger;
    }

    @Override
    public void init(@NotNull EglCoreFactory eglCoreFactory) {
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.logger.info(this.TAG, "Initializing render view");
        this.getRenderer().init(eglCoreFactory);
    }

    @Override
    public void release() {
        this.logger.info(this.TAG, "Releasing render view");
        this.getRenderer().release();
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.logger.info(this.TAG, "Surface destroyed, releasing EGL surface");
        this.getRenderer().releaseEglSurface();
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.updateSurfaceSize();
        this.logger.info(this.TAG, "Surface created, creating EGL surface with resource");
        DefaultEglRenderer defaultEglRenderer = this.getRenderer();
        Surface surface = holder.getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        defaultEglRenderer.createEglSurface(surface);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        Point size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.logger.debug(this.TAG, "Setting measured dimensions " + size.x + "x" + size.y);
        this.setMeasuredDimension(size.x, size.y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.getRenderer().setAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize();
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
            this.rotatedFrameWidth = frame.getRotatedWidth();
            this.rotatedFrameHeight = frame.getRotatedHeight();
            this.frameRotation = frame.getRotation();
            this.logger.info(this.TAG, "Video frame rotated size changed to " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + " with rotation " + this.frameRotation);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ SurfaceRenderView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            SurfaceRenderView.access$updateSurfaceSize(this.this$0);
                            this.this$0.requestLayout();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this.getRenderer().onVideoFrameReceived(frame);
    }

    private final void updateSurfaceSize() {
        block3: {
            block2: {
                if (!this.hardwareScaling || this.rotatedFrameWidth == 0 || this.rotatedFrameHeight == 0 || this.getWidth() == 0 || this.getHeight() == 0) break block2;
                float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
                float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
                int drawnFrameWidth = 0;
                int drawnFrameHeight = 0;
                if (frameAspectRatio > layoutAspectRatio) {
                    drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                    drawnFrameHeight = this.rotatedFrameHeight;
                } else {
                    drawnFrameWidth = this.rotatedFrameWidth;
                    drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
                }
                int width = Math.min(this.getWidth(), drawnFrameWidth);
                int height = Math.min(this.getHeight(), drawnFrameHeight);
                this.logger.info(this.TAG, "Updating surface size frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
                if (width == this.surfaceWidth && height == this.surfaceHeight) break block3;
                this.surfaceWidth = width;
                this.surfaceHeight = height;
                this.getHolder().setFixedSize(width, height);
                break block3;
            }
            this.surfaceWidth = this.surfaceHeight = 0;
            SurfaceHolder surfaceHolder = this.getHolder();
            if (surfaceHolder == null) break block3;
            surfaceHolder.setSizeFromLayout();
        }
    }

    @JvmOverloads
    public SurfaceRenderView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SurfaceRenderView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateSurfaceSize(SurfaceRenderView $this) {
        $this.updateSurfaceSize();
    }
}

