/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.backgroundreplacement;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.os.Handler;
import android.os.HandlerThread;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.BackgroundFilterVideoFrameProcessor;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.backgroundreplacement.BackgroundReplacementConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.JniUtil;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0018\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016J\u0006\u0010+\u001a\u00020#J\u0010\u0010,\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0002H\u0016J\b\u0010-\u001a\u00020#H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementVideoFrameProcessor;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "context", "Landroid/content/Context;", "configurations", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementConfiguration;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementConfiguration;)V", "DUMMY_PBUFFER_OFFSET", "", "TAG", "", "backgroundFilterVideoFrameProcessor", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/BackgroundFilterVideoFrameProcessor;", "getConfigurations", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementConfiguration;", "setConfigurations", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementConfiguration;)V", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "handler", "Landroid/os/Handler;", "sinks", "", "thread", "Landroid/os/HandlerThread;", "addVideoSink", "", "sink", "getBackgroundReplacedBitmap", "Landroid/graphics/Bitmap;", "inputBitmap", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "onVideoFrameReceived", "release", "removeVideoSink", "validateConfigs", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nBackgroundReplacementVideoFrameProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundReplacementVideoFrameProcessor.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementVideoFrameProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,155:1\n1#2:156\n32#3,2:157\n*S KotlinDebug\n*F\n+ 1 BackgroundReplacementVideoFrameProcessor.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundreplacement/BackgroundReplacementVideoFrameProcessor\n*L\n100#1:157,2\n*E\n"})
public final class BackgroundReplacementVideoFrameProcessor
implements VideoSource,
VideoSink {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Context context;
    @Nullable
    private BackgroundReplacementConfiguration configurations;
    @NotNull
    private final VideoContentHint contentHint;
    @NotNull
    private final String TAG;
    private final int DUMMY_PBUFFER_OFFSET;
    private EglCore eglCore;
    @NotNull
    private final HandlerThread thread;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Set<VideoSink> sinks;
    @NotNull
    private final BackgroundFilterVideoFrameProcessor backgroundFilterVideoFrameProcessor;

    @JvmOverloads
    public BackgroundReplacementVideoFrameProcessor(@NotNull Logger logger, @NotNull EglCoreFactory eglCoreFactory, @NotNull Context context, @Nullable BackgroundReplacementConfiguration configurations) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger = logger;
        this.context = context;
        this.configurations = configurations;
        this.contentHint = VideoContentHint.Motion;
        this.TAG = "BackgroundReplacementVideoFrameProcessor";
        this.thread = new HandlerThread(this.TAG);
        this.sinks = ConcurrentSet.Companion.createConcurrentSet();
        this.backgroundFilterVideoFrameProcessor = new BackgroundFilterVideoFrameProcessor(this.logger, this.context, this.TAG);
        this.validateConfigs();
        this.thread.start();
        this.handler = new Handler(this.thread.getLooper());
        this.handler.post(() -> BackgroundReplacementVideoFrameProcessor._init_$lambda$0(this, eglCoreFactory));
    }

    @Nullable
    public final BackgroundReplacementConfiguration getConfigurations() {
        return this.configurations;
    }

    public final void setConfigurations(@Nullable BackgroundReplacementConfiguration backgroundReplacementConfiguration) {
        this.configurations = backgroundReplacementConfiguration;
    }

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        frame.retain();
        this.handler.post(() -> BackgroundReplacementVideoFrameProcessor.onVideoFrameReceived$lambda$2(this, frame));
    }

    @Nullable
    public final Bitmap getBackgroundReplacedBitmap(@NotNull Bitmap inputBitmap, @NotNull VideoFrame frame) {
        Bitmap bitmap;
        BackgroundReplacementConfiguration backgroundReplacementConfiguration;
        Bitmap upScaledMaskedBitmap;
        Bitmap maskedBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Bitmap scaledInputBitmap = this.backgroundFilterVideoFrameProcessor.getScaledInputBitmap(frame, inputBitmap);
        Bitmap bitmap2 = maskedBitmap = this.backgroundFilterVideoFrameProcessor.getSegmentationMask(scaledInputBitmap);
        if (bitmap2 != null) {
            Bitmap it = bitmap2;
            boolean bl = false;
            v1 = Bitmap.createScaledBitmap((Bitmap)it, (int)frame.getRotatedWidth(), (int)frame.getRotatedHeight(), (boolean)true);
        } else {
            v1 = upScaledMaskedBitmap = null;
        }
        if ((backgroundReplacementConfiguration = this.configurations) != null && (backgroundReplacementConfiguration = backgroundReplacementConfiguration.getImage()) != null) {
            BackgroundReplacementConfiguration it = backgroundReplacementConfiguration;
            boolean bl = false;
            bitmap = Bitmap.createScaledBitmap((Bitmap)it, (int)frame.getRotatedWidth(), (int)frame.getRotatedHeight(), (boolean)false);
        } else {
            bitmap = null;
        }
        Bitmap replacementBitmap = bitmap;
        return this.backgroundFilterVideoFrameProcessor.drawImageWithMask(inputBitmap, upScaledMaskedBitmap, replacementBitmap);
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    private final void validateConfigs() {
        if (this.configurations == null) {
            this.configurations = new BackgroundReplacementConfiguration(null, 1, null);
        }
    }

    public final void release() {
        this.handler.post(() -> BackgroundReplacementVideoFrameProcessor.release$lambda$5(this));
    }

    private static final void _init_$lambda$0(BackgroundReplacementVideoFrameProcessor this$0, EglCoreFactory $eglCoreFactory) {
        EglCore eglCore;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eglCoreFactory, (String)"$eglCoreFactory");
        this$0.eglCore = $eglCoreFactory.createEglCore();
        int[] nArray = new int[]{12375, 1, 12374, 1, 12344};
        int[] surfaceAttribs = nArray;
        EglCore eglCore2 = this$0.eglCore;
        if (eglCore2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore2 = null;
        }
        if ((eglCore = this$0.eglCore) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore = null;
        }
        EGLDisplay eGLDisplay = eglCore.getEglDisplay();
        EglCore eglCore3 = this$0.eglCore;
        if (eglCore3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore3 = null;
        }
        EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eGLDisplay, (EGLConfig)eglCore3.getEglConfig(), (int[])surfaceAttribs, (int)this$0.DUMMY_PBUFFER_OFFSET);
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglCreatePbufferSurface(...)");
        eglCore2.setEglSurface(eGLSurface);
        EglCore eglCore4 = this$0.eglCore;
        if (eglCore4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore4 = null;
        }
        EGLDisplay eGLDisplay2 = eglCore4.getEglDisplay();
        EglCore eglCore5 = this$0.eglCore;
        if (eglCore5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore5 = null;
        }
        EGLSurface eGLSurface2 = eglCore5.getEglSurface();
        EglCore eglCore6 = this$0.eglCore;
        if (eglCore6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore6 = null;
        }
        EGLSurface eGLSurface3 = eglCore6.getEglSurface();
        EglCore eglCore7 = this$0.eglCore;
        if (eglCore7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore7 = null;
        }
        EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay2, (EGLSurface)eGLSurface2, (EGLSurface)eGLSurface3, (EGLContext)eglCore7.getEglContext());
        GlUtil.INSTANCE.checkGlError("Failed to set dummy surface to initialize surface texture video source");
        this$0.logger.info(this$0.TAG, "Created " + this$0.TAG);
    }

    private static final void onVideoFrameReceived$lambda$2(BackgroundReplacementVideoFrameProcessor this$0, VideoFrame $frame) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$frame, (String)"$frame");
        ByteBuffer rgbaData = this$0.backgroundFilterVideoFrameProcessor.getByteBufferFromInputVideoFrame($frame);
        Bitmap inputBitmap = this$0.backgroundFilterVideoFrameProcessor.getInputBitmap($frame);
        Bitmap backgroundReplacedBitmap = this$0.getBackgroundReplacedBitmap(inputBitmap, $frame);
        VideoFrame processedFrame = this$0.backgroundFilterVideoFrameProcessor.getProcessedFrame($frame, backgroundReplacedBitmap, rgbaData);
        $frame.release();
        Iterator<VideoSink> $this$forEach$iv = this$0.sinks.iterator();
        boolean $i$f$forEach = false;
        Iterator<VideoSink> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            VideoSink element$iv;
            VideoSink it = element$iv = iterator.next();
            boolean bl = false;
            it.onVideoFrameReceived(processedFrame);
        }
        processedFrame.release();
        JniUtil.nativeFreeByteBuffer((ByteBuffer)rgbaData);
    }

    private static final void release$lambda$5(BackgroundReplacementVideoFrameProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logger.info(this$0.TAG, "Releasing " + this$0.TAG + " source");
        this$0.backgroundFilterVideoFrameProcessor.release();
        EglCore eglCore = this$0.eglCore;
        if (eglCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
            eglCore = null;
        }
        eglCore.release();
        this$0.handler.getLooper().quit();
    }
}

