/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.backgroundblur;

import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BlurProcessor;", "", "rs", "Landroid/renderscript/RenderScript;", "(Landroid/renderscript/RenderScript;)V", "blurScript", "Landroid/renderscript/ScriptIntrinsicBlur;", "height", "", "inAllocation", "Landroid/renderscript/Allocation;", "outAllocation", "width", "initialize", "", "blurStrength", "", "process", "Landroid/graphics/Bitmap;", "bitmap", "release", "amazon-chime-sdk_release"})
public final class BlurProcessor {
    @NotNull
    private final RenderScript rs;
    @Nullable
    private Allocation inAllocation;
    @Nullable
    private Allocation outAllocation;
    private int width;
    private int height;
    @Nullable
    private ScriptIntrinsicBlur blurScript;

    public BlurProcessor(@NotNull RenderScript rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        this.rs = rs;
    }

    public final void initialize(int width, int height, float blurStrength) {
        this.width = width;
        this.height = height;
        ScriptIntrinsicBlur scriptIntrinsicBlur = this.blurScript = ScriptIntrinsicBlur.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        if (scriptIntrinsicBlur != null) {
            scriptIntrinsicBlur.setRadius(blurStrength);
        }
        if (this.outAllocation != null) {
            Allocation allocation = this.outAllocation;
            if (allocation != null) {
                allocation.destroy();
            }
            this.outAllocation = null;
        }
        Type bitmapType = new Type.Builder(this.rs, Element.RGBA_8888((RenderScript)this.rs)).setX(width).setY(height).setMipmaps(false).create();
        this.outAllocation = Allocation.createTyped((RenderScript)this.rs, (Type)bitmapType);
        this.inAllocation = Allocation.createTyped((RenderScript)this.rs, (Type)bitmapType);
    }

    public final void release() {
        ScriptIntrinsicBlur scriptIntrinsicBlur = this.blurScript;
        if (scriptIntrinsicBlur != null) {
            scriptIntrinsicBlur.destroy();
        }
        this.blurScript = null;
        Allocation allocation = this.inAllocation;
        if (allocation != null) {
            allocation.destroy();
        }
        this.inAllocation = null;
        Allocation allocation2 = this.outAllocation;
        if (allocation2 != null) {
            allocation2.destroy();
        }
        this.outAllocation = null;
    }

    @Nullable
    public final Bitmap process(@NotNull Bitmap bitmap) {
        Bitmap blurredBitmap;
        block4: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Bitmap.Config bitmapConfig = Bitmap.Config.ARGB_8888;
            Bitmap.Config config = bitmap.getConfig();
            boolean bl = config != null ? !config.equals((Object)bitmapConfig) : false;
            if (bl) {
                throw new Exception("Bitmap must have ARGB_8888 config.");
            }
            Allocation allocation = this.inAllocation;
            if (allocation != null) {
                allocation.copyFrom(bitmap);
            }
            ScriptIntrinsicBlur scriptIntrinsicBlur = this.blurScript;
            if (scriptIntrinsicBlur != null) {
                scriptIntrinsicBlur.setInput(this.inAllocation);
            }
            ScriptIntrinsicBlur scriptIntrinsicBlur2 = this.blurScript;
            if (scriptIntrinsicBlur2 != null) {
                scriptIntrinsicBlur2.forEach(this.outAllocation);
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)bitmapConfig);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
            blurredBitmap = bitmap2;
            Allocation allocation2 = this.outAllocation;
            if (allocation2 == null) break block4;
            allocation2.copyTo(blurredBitmap);
        }
        return blurredBitmap;
    }
}

