/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video;

import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientLifecycleHandler;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientStateController;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientStateController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "TAG", "", "lifecycleHandler", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientLifecycleHandler;", "videoClientState", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientState;", "bindLifecycleHandler", "", "canAct", "", "minimalRequiredState", "start", "stop", "updateState", "newState", "amazon-chime-sdk_release"})
public final class DefaultVideoClientStateController
implements VideoClientStateController {
    @NotNull
    private final Logger logger;
    @NotNull
    private final String TAG;
    @NotNull
    private VideoClientState videoClientState;
    @Nullable
    private VideoClientLifecycleHandler lifecycleHandler;

    public DefaultVideoClientStateController(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.TAG = "DefaultVideoClientStateController";
        this.videoClientState = VideoClientState.UNINITIALIZED;
    }

    @Override
    public void bindLifecycleHandler(@NotNull VideoClientLifecycleHandler lifecycleHandler) {
        Intrinsics.checkNotNullParameter((Object)lifecycleHandler, (String)"lifecycleHandler");
        this.lifecycleHandler = lifecycleHandler;
    }

    @Override
    public void updateState(@NotNull VideoClientState newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.videoClientState = newState;
    }

    @Override
    public void start() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.videoClientState.ordinal()]) {
            case 1: {
                VideoClientLifecycleHandler videoClientLifecycleHandler = this.lifecycleHandler;
                if (videoClientLifecycleHandler != null) {
                    videoClientLifecycleHandler.initializeVideoClient();
                }
                VideoClientLifecycleHandler videoClientLifecycleHandler2 = this.lifecycleHandler;
                if (videoClientLifecycleHandler2 != null) {
                    videoClientLifecycleHandler2.startVideoClient();
                }
                this.videoClientState = VideoClientState.STARTED;
                break;
            }
            case 2: 
            case 3: {
                VideoClientLifecycleHandler videoClientLifecycleHandler = this.lifecycleHandler;
                if (videoClientLifecycleHandler != null) {
                    videoClientLifecycleHandler.startVideoClient();
                }
                this.videoClientState = VideoClientState.STARTED;
                break;
            }
            default: {
                this.logger.warn(this.TAG, "VideoClient is already in a start state, ignoring");
            }
        }
    }

    @Override
    public void stop() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.videoClientState.ordinal()]) {
            case 4: {
                VideoClientLifecycleHandler videoClientLifecycleHandler = this.lifecycleHandler;
                if (videoClientLifecycleHandler != null) {
                    videoClientLifecycleHandler.stopVideoClient();
                }
                VideoClientLifecycleHandler videoClientLifecycleHandler2 = this.lifecycleHandler;
                if (videoClientLifecycleHandler2 != null) {
                    videoClientLifecycleHandler2.destroyVideoClient();
                }
                this.videoClientState = VideoClientState.UNINITIALIZED;
                break;
            }
            case 2: 
            case 3: {
                VideoClientLifecycleHandler videoClientLifecycleHandler = this.lifecycleHandler;
                if (videoClientLifecycleHandler != null) {
                    videoClientLifecycleHandler.destroyVideoClient();
                }
                this.videoClientState = VideoClientState.UNINITIALIZED;
                break;
            }
            default: {
                this.logger.warn(this.TAG, "VideoClient is already in an uninitialized state, ignoring");
            }
        }
    }

    @Override
    public boolean canAct(@NotNull VideoClientState minimalRequiredState) {
        Intrinsics.checkNotNullParameter((Object)((Object)minimalRequiredState), (String)"minimalRequiredState");
        if (this.videoClientState.compareTo((Enum)minimalRequiredState) >= 0) {
            return true;
        }
        this.logger.warn(this.TAG, "Video client is not at " + (Object)((Object)minimalRequiredState) + " state or higher, ignoring action");
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoClientState.values().length];
            try {
                nArray[VideoClientState.UNINITIALIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoClientState.INITIALIZED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoClientState.STOPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoClientState.STARTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

