/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.metric;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.metric.MetricsObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.metric.ObservableMetric;
import com.amazonaws.services.chime.sdk.meetings.internal.metric.ClientMetricsCollector;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u001c\u0010\u0014\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/DefaultClientMetricsCollector;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;", "()V", "METRICS_EMISSION_INTERVAL_MS", "", "cachedObservableMetrics", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/metric/ObservableMetric;", "", "lastEmittedMetricsTime", "", "metricsObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/metric/MetricsObserver;", "maybeEmitMetrics", "", "processAudioClientMetrics", "metrics", "", "processContentShareVideoClientMetrics", "processVideoClientMetrics", "subscribeToMetrics", "observer", "unsubscribeFromMetrics", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultClientMetricsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultClientMetricsCollector.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/metric/DefaultClientMetricsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,87:1\n494#2,7:88\n*S KotlinDebug\n*F\n+ 1 DefaultClientMetricsCollector.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/metric/DefaultClientMetricsCollector\n*L\n73#1:88,7\n*E\n"})
public final class DefaultClientMetricsCollector
implements ClientMetricsCollector {
    @NotNull
    private Set<MetricsObserver> metricsObservers = ConcurrentSet.Companion.createConcurrentSet();
    @NotNull
    private Map<ObservableMetric, Double> cachedObservableMetrics = new LinkedHashMap();
    private long lastEmittedMetricsTime = Calendar.getInstance().getTimeInMillis();
    private final int METRICS_EMISSION_INTERVAL_MS;

    public DefaultClientMetricsCollector() {
        this.METRICS_EMISSION_INTERVAL_MS = 1000;
    }

    @Override
    public void processAudioClientMetrics(@NotNull Map<Integer, Double> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.cachedObservableMetrics.put(ObservableMetric.audioReceivePacketLossPercent, metrics.get(7));
        this.cachedObservableMetrics.put(ObservableMetric.audioSendPacketLossPercent, metrics.get(3));
        this.maybeEmitMetrics();
    }

    @Override
    public void processVideoClientMetrics(@NotNull Map<Integer, Double> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.cachedObservableMetrics.put(ObservableMetric.videoAvailableSendBandwidth, metrics.get(0));
        this.cachedObservableMetrics.put(ObservableMetric.videoAvailableReceiveBandwidth, metrics.get(1));
        this.cachedObservableMetrics.put(ObservableMetric.videoSendBitrate, metrics.get(2));
        this.cachedObservableMetrics.put(ObservableMetric.videoSendPacketLossPercent, metrics.get(3));
        this.cachedObservableMetrics.put(ObservableMetric.videoSendFps, metrics.get(4));
        this.cachedObservableMetrics.put(ObservableMetric.videoSendRttMs, metrics.get(5));
        this.cachedObservableMetrics.put(ObservableMetric.videoReceiveBitrate, metrics.get(6));
        this.cachedObservableMetrics.put(ObservableMetric.videoReceivePacketLossPercent, metrics.get(7));
        this.maybeEmitMetrics();
    }

    @Override
    public void processContentShareVideoClientMetrics(@NotNull Map<Integer, Double> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.cachedObservableMetrics.put(ObservableMetric.contentShareVideoSendBitrate, metrics.get(2));
        this.cachedObservableMetrics.put(ObservableMetric.contentShareVideoSendPacketLossPercent, metrics.get(3));
        this.cachedObservableMetrics.put(ObservableMetric.contentShareVideoSendFps, metrics.get(4));
        this.cachedObservableMetrics.put(ObservableMetric.contentShareVideoSendRttMs, metrics.get(5));
        this.maybeEmitMetrics();
    }

    /*
     * WARNING - void declaration
     */
    private final void maybeEmitMetrics() {
        long now = Calendar.getInstance().getTimeInMillis();
        if (!this.cachedObservableMetrics.isEmpty() && now - this.lastEmittedMetricsTime > (long)this.METRICS_EMISSION_INTERVAL_MS) {
            void $this$filterValues$iv;
            this.lastEmittedMetricsTime = now;
            Ref.ObjectRef cachedObservableMetricsWithoutNullValues = new Ref.ObjectRef();
            Map<ObservableMetric, Double> map = this.cachedObservableMetrics;
            Ref.ObjectRef objectRef = cachedObservableMetricsWithoutNullValues;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                Double it = (Double)entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            objectRef.element = result$iv;
            ObserverUtils.Companion.notifyObserverOnMainThread(this.metricsObservers, (Function1)new Function1<MetricsObserver, Unit>((Ref.ObjectRef<Map<ObservableMetric, Object>>)cachedObservableMetricsWithoutNullValues){
                final /* synthetic */ Ref.ObjectRef<Map<ObservableMetric, Object>> $cachedObservableMetricsWithoutNullValues;
                {
                    this.$cachedObservableMetricsWithoutNullValues = $cachedObservableMetricsWithoutNullValues;
                    super(1);
                }

                public final void invoke(@NotNull MetricsObserver it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onMetricsReceived((Map)this.$cachedObservableMetricsWithoutNullValues.element);
                }
            });
        }
    }

    @Override
    public void subscribeToMetrics(@NotNull MetricsObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.metricsObservers.add(observer);
    }

    @Override
    public void unsubscribeFromMetrics(@NotNull MetricsObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.metricsObservers.remove(observer);
    }
}

