/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion;

import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionEvent;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionRecord;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.DirtyMeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.MeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.EventAttributesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\r\u001a\u00020\u000eJ.\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002J.\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u00132\u0006\u0010\u0017\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002J:\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002J.\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002J.\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u001a2\u0006\u0010\u001c\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/IngestionEventConverter;", "", "()V", "ID_KEY", "", "NAME_KEY", "TIMESTAMP_KEY", "TTL_KEY", "fromDirtyMeetingEventItems", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionRecord;", "items", "", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/DirtyMeetingEventItem;", "ingestionConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionConfiguration;", "fromMeetingEventItems", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/MeetingEventItem;", "toIngestionMetadata", "", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionMetadata;", "dirtyEventItem", "metadataAttributeKeys", "", "eventItem", "eventAttributes", "toIngestionPayload", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionPayload;", "dirtyEvent", "event", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nIngestionEventConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IngestionEventConverter.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/IngestionEventConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,148:1\n1477#2:149\n1502#2,3:150\n1505#2,3:160\n1549#2:166\n1620#2,3:167\n1477#2:171\n1502#2,3:172\n1505#2,3:182\n1549#2:188\n1620#2,3:189\n372#3,7:153\n372#3,7:175\n551#3:193\n536#3,6:194\n551#3:202\n536#3,6:203\n125#4:163\n152#4,2:164\n154#4:170\n125#4:185\n152#4,2:186\n154#4:192\n215#4,2:200\n215#4,2:209\n*S KotlinDebug\n*F\n+ 1 IngestionEventConverter.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/ingestion/IngestionEventConverter\n*L\n46#1:149\n46#1:150,3\n46#1:160,3\n55#1:166\n55#1:167,3\n74#1:171\n74#1:172,3\n74#1:182,3\n84#1:188\n84#1:189,3\n46#1:153,7\n74#1:175,7\n124#1:193\n124#1:194,6\n140#1:202\n140#1:203,6\n51#1:163\n51#1:164,2\n51#1:170\n80#1:185\n80#1:186,2\n80#1:192\n125#1:200,2\n141#1:209,2\n*E\n"})
public final class IngestionEventConverter {
    @NotNull
    public static final IngestionEventConverter INSTANCE = new IngestionEventConverter();
    @NotNull
    private static final String NAME_KEY = "name";
    @NotNull
    private static final String TIMESTAMP_KEY = "ts";
    @NotNull
    private static final String ID_KEY = "id";
    @NotNull
    private static final String TTL_KEY = "ttl";

    private IngestionEventConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IngestionRecord fromDirtyMeetingEventItems(@NotNull List<DirtyMeetingEventItem> items, @NotNull IngestionConfiguration ingestionConfiguration) {
        void $this$mapTo$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Map.Entry entry;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)ingestionConfiguration, (String)"ingestionConfiguration");
        if (items.isEmpty()) {
            return new IngestionRecord(new LinkedHashMap(), CollectionsKt.emptyList());
        }
        Iterable $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DirtyMeetingEventItem it = (DirtyMeetingEventItem)element$iv$iv;
            boolean bl = false;
            entry = it.getData().getEventAttributes().get("meetingId");
            String string = entry instanceof String ? (String)((Object)entry) : null;
            if (string == null) {
                string = "";
            }
            String key$iv$iv = string;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map dirtyMeetingEventsByMeetingId = destination$iv$iv;
        Set<String> eventMetadataKeys = ingestionConfiguration.getClientConfiguration().getMetadataAttributes().keySet();
        Map $this$map$iv = dirtyMeetingEventsByMeetingId;
        boolean $i$f$map = false;
        Map $i$f$groupByTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<Map<String, Object>> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            Map.Entry item$iv$iv;
            entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            $this$getOrPut$iv$iv$iv = (Iterable)it.getValue();
            Map<String, Object> map = INSTANCE.toIngestionMetadata((DirtyMeetingEventItem)CollectionsKt.first((List)((List)it.getValue())), eventMetadataKeys);
            String string = ingestionConfiguration.getClientConfiguration().getTag();
            boolean $i$f$map2 = false;
            void var20_28 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void meetingEventItem;
                DirtyMeetingEventItem dirtyMeetingEventItem = (DirtyMeetingEventItem)item$iv$iv2;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add(INSTANCE.toIngestionPayload((DirtyMeetingEventItem)meetingEventItem, eventMetadataKeys));
            }
            collection = (List)destination$iv$iv3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            int n2 = 0;
            List list = collection;
            Map<String, Object> map2 = map;
            String string2 = string;
            collection2.add(new IngestionEvent(string2, map2, list, n2, n, defaultConstructorMarker));
        }
        List ingestionEvents = (List)destination$iv$iv2;
        Map<String, Object> rootMetadata = EventAttributesUtils.INSTANCE.getIngestionMetadata(ingestionConfiguration);
        return new IngestionRecord(rootMetadata, ingestionEvents);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IngestionRecord fromMeetingEventItems(@NotNull List<MeetingEventItem> items, @NotNull IngestionConfiguration ingestionConfiguration) {
        void $this$mapTo$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Map.Entry entry;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)ingestionConfiguration, (String)"ingestionConfiguration");
        if (items.isEmpty()) {
            return new IngestionRecord(new LinkedHashMap(), CollectionsKt.emptyList());
        }
        Iterable $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MeetingEventItem it = (MeetingEventItem)element$iv$iv;
            boolean bl = false;
            entry = it.getData().getEventAttributes().get("meetingId");
            String string = entry instanceof String ? (String)((Object)entry) : null;
            if (string == null) {
                string = "";
            }
            String key$iv$iv = string;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map meetingEventsByMeetingId = destination$iv$iv;
        Set<String> eventMetadataKeys = ingestionConfiguration.getClientConfiguration().getMetadataAttributes().keySet();
        Map $this$map$iv = meetingEventsByMeetingId;
        boolean $i$f$map = false;
        Map $i$f$groupByTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<Map<String, Object>> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            Map.Entry item$iv$iv;
            entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            $this$getOrPut$iv$iv$iv = (Iterable)it.getValue();
            Map<String, Object> map = INSTANCE.toIngestionMetadata((MeetingEventItem)CollectionsKt.first((List)((List)it.getValue())), eventMetadataKeys);
            String string = ingestionConfiguration.getClientConfiguration().getTag();
            boolean $i$f$map2 = false;
            void var20_28 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void meetingEventItem;
                MeetingEventItem meetingEventItem2 = (MeetingEventItem)item$iv$iv2;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add(INSTANCE.toIngestionPayload((MeetingEventItem)meetingEventItem, eventMetadataKeys));
            }
            collection = (List)destination$iv$iv3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            int n2 = 0;
            List list = collection;
            Map<String, Object> map2 = map;
            String string2 = string;
            collection2.add(new IngestionEvent(string2, map2, list, n2, n, defaultConstructorMarker));
        }
        List ingestionEvents = (List)destination$iv$iv2;
        Map<String, Object> rootMetadata = EventAttributesUtils.INSTANCE.getIngestionMetadata(ingestionConfiguration);
        return new IngestionRecord(rootMetadata, ingestionEvents);
    }

    private final Map<String, Object> toIngestionMetadata(MeetingEventItem eventItem, Set<String> metadataAttributeKeys) {
        return this.toIngestionMetadata(eventItem.getData().getEventAttributes(), metadataAttributeKeys);
    }

    private final Map<String, Object> toIngestionMetadata(DirtyMeetingEventItem dirtyEventItem, Set<String> metadataAttributeKeys) {
        return this.toIngestionMetadata(dirtyEventItem.getData().getEventAttributes(), metadataAttributeKeys);
    }

    private final Map<String, Object> toIngestionMetadata(Map<String, ? extends Object> eventAttributes, Set<String> metadataAttributeKeys) {
        Map ingestionMetadata = new LinkedHashMap();
        for (String attributeName : metadataAttributeKeys) {
            Object it;
            Object value = eventAttributes.get(attributeName);
            if (value == null) continue;
            boolean bl = false;
            ingestionMetadata.put(attributeName, it);
        }
        return ingestionMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toIngestionPayload(MeetingEventItem event, Set<String> metadataAttributeKeys) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)NAME_KEY, (Object)event.getData().getName());
        Object object = event.getData().getEventAttributes().get("timestampMs");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        pairArray[1] = TuplesKt.to((Object)TIMESTAMP_KEY, (Object)((long)((Double)object).doubleValue()));
        pairArray[2] = TuplesKt.to((Object)ID_KEY, (Object)event.getId());
        Map payload = MapsKt.mutableMapOf((Pair[])pairArray);
        Map $this$filterNot$iv = event.getData().getEventAttributes();
        boolean $i$f$filterNot = false;
        Object object2 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (metadataAttributeKeys.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            payload.put(it.getKey(), it.getValue());
        }
        return payload;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toIngestionPayload(DirtyMeetingEventItem dirtyEvent, Set<String> metadataAttributeKeys) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)NAME_KEY, (Object)dirtyEvent.getData().getName());
        pairArray[1] = TuplesKt.to((Object)TTL_KEY, (Object)dirtyEvent.getTtl());
        Object object = dirtyEvent.getData().getEventAttributes().get("timestampMs");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
        pairArray[2] = TuplesKt.to((Object)TIMESTAMP_KEY, (Object)((long)((Double)object).doubleValue()));
        pairArray[3] = TuplesKt.to((Object)ID_KEY, (Object)dirtyEvent.getId());
        Map payload = MapsKt.mutableMapOf((Pair[])pairArray);
        Map $this$filterNot$iv = dirtyEvent.getData().getEventAttributes();
        boolean $i$f$filterNot = false;
        Object object2 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (metadataAttributeKeys.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filterNot$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            payload.put(it.getKey(), it.getValue());
        }
        return payload;
    }
}

